/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class LSPRenameProcessor
extends RefactoringProcessor {
    private static final String ID = "org.eclipse.lsp4e.operations.rename";
    private final LanguageServiceAccessor.LSPDocumentInfo info;
    private final int offset;
    private String newName;
    private WorkspaceEdit rename;

    public LSPRenameProcessor(LanguageServiceAccessor.LSPDocumentInfo info, int offset) {
        this.info = info;
        this.offset = offset;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return ID;
    }

    public String getProcessorName() {
        return Messages.rename_processor_name;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            RenameParams params = new RenameParams();
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.info.getDocument()));
            TextDocumentIdentifier identifier = new TextDocumentIdentifier();
            identifier.setUri(this.info.getFileUri().toString());
            params.setTextDocument(identifier);
            params.setNewName(this.newName);
            if (params.getNewName() != null) {
                this.rename = (WorkspaceEdit)((CompletableFuture)this.info.getInitializedLanguageClient().thenCompose(langaugeServer -> langaugeServer.getTextDocumentService().rename(params))).get(1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            status.addError(e.getMessage());
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.rename == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", Messages.rename_processor_required));
        }
        return LSPEclipseUtils.toCompositeChange(this.rename);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return null;
    }

    public void setNewName(String newName) {
        Assert.isNotNull((Object)newName);
        this.newName = newName;
    }
}

