/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import com.google.common.base.MoreObjects;

/**
 * Response to 'continue' request.
 */
@SuppressWarnings("all")
public class ContinueResponse {
  /**
   * The value {@code true} (or a missing property) signals to the client that all
   * threads have been resumed. The value {@code false} indicates that not all
   * threads were resumed.
   * <p>
   * This is an optional property.
   */
  private Boolean allThreadsContinued;

  /**
   * The value {@code true} (or a missing property) signals to the client that all
   * threads have been resumed. The value {@code false} indicates that not all
   * threads were resumed.
   * <p>
   * This is an optional property.
   */
  public Boolean getAllThreadsContinued() {
    return this.allThreadsContinued;
  }

  /**
   * The value {@code true} (or a missing property) signals to the client that all
   * threads have been resumed. The value {@code false} indicates that not all
   * threads were resumed.
   * <p>
   * This is an optional property.
   */
  public void setAllThreadsContinued(final Boolean allThreadsContinued) {
    this.allThreadsContinued = allThreadsContinued;
  }

  @Override
  public String toString() {
    MoreObjects.ToStringHelper b = MoreObjects.toStringHelper(this);
    b.add("allThreadsContinued", this.allThreadsContinued);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ContinueResponse other = (ContinueResponse) obj;
    if (this.allThreadsContinued == null) {
      if (other.allThreadsContinued != null)
        return false;
    } else if (!this.allThreadsContinued.equals(other.allThreadsContinued))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.allThreadsContinued== null) ? 0 : this.allThreadsContinued.hashCode());
  }
}
