/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import com.google.common.base.MoreObjects;

/**
 * Arguments for 'stepIn' request.
 */
@SuppressWarnings("all")
public class StepInArguments {
  /**
   * Specifies the thread for which to resume execution for one step-into (of
   * the given granularity).
   */
  private int threadId;

  /**
   * If this flag is true, all other suspended threads are not resumed.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  private Boolean singleThread;

  /**
   * Id of the target to step into.
   * <p>
   * This is an optional property.
   */
  private Integer targetId;

  /**
   * Stepping granularity. If no granularity is specified, a granularity of 'statement' is assumed.
   * <p>
   * This is an optional property.
   */
  private SteppingGranularity granularity;

  /**
   * Specifies the thread for which to resume execution for one step-into (of
   * the given granularity).
   */
  public int getThreadId() {
    return this.threadId;
  }

  /**
   * Specifies the thread for which to resume execution for one step-into (of
   * the given granularity).
   */
  public void setThreadId(final int threadId) {
    this.threadId = threadId;
  }

  /**
   * If this flag is true, all other suspended threads are not resumed.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  public Boolean getSingleThread() {
    return this.singleThread;
  }

  /**
   * If this flag is true, all other suspended threads are not resumed.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  public void setSingleThread(final Boolean singleThread) {
    this.singleThread = singleThread;
  }

  /**
   * Id of the target to step into.
   * <p>
   * This is an optional property.
   */
  public Integer getTargetId() {
    return this.targetId;
  }

  /**
   * Id of the target to step into.
   * <p>
   * This is an optional property.
   */
  public void setTargetId(final Integer targetId) {
    this.targetId = targetId;
  }

  /**
   * Stepping granularity. If no granularity is specified, a granularity of 'statement' is assumed.
   * <p>
   * This is an optional property.
   */
  public SteppingGranularity getGranularity() {
    return this.granularity;
  }

  /**
   * Stepping granularity. If no granularity is specified, a granularity of 'statement' is assumed.
   * <p>
   * This is an optional property.
   */
  public void setGranularity(final SteppingGranularity granularity) {
    this.granularity = granularity;
  }

  @Override
  public String toString() {
    MoreObjects.ToStringHelper b = MoreObjects.toStringHelper(this);
    b.add("threadId", this.threadId);
    b.add("singleThread", this.singleThread);
    b.add("targetId", this.targetId);
    b.add("granularity", this.granularity);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    StepInArguments other = (StepInArguments) obj;
    if (other.threadId != this.threadId)
      return false;
    if (this.singleThread == null) {
      if (other.singleThread != null)
        return false;
    } else if (!this.singleThread.equals(other.singleThread))
      return false;
    if (this.targetId == null) {
      if (other.targetId != null)
        return false;
    } else if (!this.targetId.equals(other.targetId))
      return false;
    if (this.granularity == null) {
      if (other.granularity != null)
        return false;
    } else if (!this.granularity.equals(other.granularity))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + this.threadId;
    result = prime * result + ((this.singleThread== null) ? 0 : this.singleThread.hashCode());
    result = prime * result + ((this.targetId== null) ? 0 : this.targetId.hashCode());
    return prime * result + ((this.granularity== null) ? 0 : this.granularity.hashCode());
  }
}
