/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import com.google.common.base.MoreObjects;

/**
 * Provides formatting information for a value.
 */
@SuppressWarnings("all")
public class ValueFormat {
  /**
   * Display the value in hex.
   * <p>
   * This is an optional property.
   */
  private Boolean hex;

  /**
   * Display the value in hex.
   * <p>
   * This is an optional property.
   */
  public Boolean getHex() {
    return this.hex;
  }

  /**
   * Display the value in hex.
   * <p>
   * This is an optional property.
   */
  public void setHex(final Boolean hex) {
    this.hex = hex;
  }

  @Override
  public String toString() {
    MoreObjects.ToStringHelper b = MoreObjects.toStringHelper(this);
    b.add("hex", this.hex);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ValueFormat other = (ValueFormat) obj;
    if (this.hex == null) {
      if (other.hex != null)
        return false;
    } else if (!this.hex.equals(other.hex))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.hex== null) ? 0 : this.hex.hashCode());
  }
}
