/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.generator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.lsp4j.generator.EitherTypeArgument;
import org.eclipse.lsp4j.generator.JsonRpcData;
import org.eclipse.lsp4j.generator.JsonRpcDataTransformationContext;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtend.lib.annotations.AccessorsProcessor;
import org.eclipse.xtend.lib.annotations.EqualsHashCodeProcessor;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class JsonRpcDataProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration annotatedClass, TransformationContext context) {
        this.generateImpl(annotatedClass, context);
    }

    protected MutableClassDeclaration generateImpl(MutableClassDeclaration impl, @Extension TransformationContext context) {
        Functions.Function1 _function = it -> {
            AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
            Type _findTypeGlobally = context.findTypeGlobally(JsonRpcData.class);
            return Objects.equal((Object)_annotationTypeDeclaration, (Object)_findTypeGlobally);
        };
        impl.removeAnnotation((AnnotationReference)IterableExtensions.findFirst((Iterable)impl.getAnnotations(), (Functions.Function1)_function));
        JsonRpcDataTransformationContext _jsonRpcDataTransformationContext = new JsonRpcDataTransformationContext(context);
        this.generateImplMembers(impl, _jsonRpcDataTransformationContext);
        this.generateToString(impl, context);
        Type _type = impl.getExtendedClass().getType();
        Type _type_1 = context.newTypeReference(Object.class, new TypeReference[0]).getType();
        boolean shouldIncludeSuper = !Objects.equal((Object)_type, (Object)_type_1);
        EqualsHashCodeProcessor.Util equalsHashCodeUtil = new EqualsHashCodeProcessor.Util(context);
        Functions.Function1 _function_1 = it -> {
            boolean _isStatic = it.isStatic();
            return !_isStatic;
        };
        Iterable fields = IterableExtensions.filter((Iterable)impl.getDeclaredFields(), (Functions.Function1)_function_1);
        equalsHashCodeUtil.addEquals(impl, fields, shouldIncludeSuper);
        equalsHashCodeUtil.addHashCode(impl, fields, shouldIncludeSuper);
        Consumer<MutableMethodDeclaration> _function_2 = method -> {
            AnnotationReference purified = method.findAnnotation(context.findTypeGlobally(Pure.class));
            if (purified != null) {
                method.removeAnnotation(purified);
            }
        };
        impl.getDeclaredMethods().forEach(_function_2);
        return impl;
    }

    protected void generateImplMembers(MutableClassDeclaration impl, @Extension JsonRpcDataTransformationContext context) {
        Functions.Function1 _function = it -> {
            boolean _isStatic = it.isStatic();
            return !_isStatic;
        };
        Consumer<MutableFieldDeclaration> _function_1 = field -> {
            boolean _not;
            AccessorsProcessor.Util accessorsUtil = new AccessorsProcessor.Util((TransformationContext)context);
            AnnotationReference deprecated = field.findAnnotation(context.findTypeGlobally(Deprecated.class));
            accessorsUtil.addGetter(field, Visibility.PUBLIC);
            AnnotationReference _findAnnotation = field.findAnnotation(context.newTypeReference(NonNull.class, new TypeReference[0]).getType());
            boolean hasNonNull = _findAnnotation != null;
            AnnotationReference _findAnnotation_1 = field.findAnnotation(context.newTypeReference(JsonAdapter.class, new TypeReference[0]).getType());
            boolean hasJsonAdapter = _findAnnotation_1 != null;
            MutableMethodDeclaration _findDeclaredMethod = impl.findDeclaredMethod(accessorsUtil.getGetterName((FieldDeclaration)field), new TypeReference[0]);
            Procedures.Procedure1 _function_2 = it -> {
                it.setDocComment(field.getDocComment());
                if (hasNonNull) {
                    it.addAnnotation(context.newAnnotationReference(NonNull.class));
                }
                if (deprecated != null) {
                    it.addAnnotation(context.newAnnotationReference(Deprecated.class));
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_findDeclaredMethod, (Procedures.Procedure1)_function_2);
            boolean _isInferred = field.getType().isInferred();
            boolean bl = _not = !_isInferred;
            if (_not) {
                boolean _not_1;
                accessorsUtil.addSetter(field, Visibility.PUBLIC);
                String setterName = accessorsUtil.getSetterName((FieldDeclaration)field);
                MutableMethodDeclaration _findDeclaredMethod_1 = impl.findDeclaredMethod(setterName, new TypeReference[]{field.getType()});
                Procedures.Procedure1 _function_3 = it -> {
                    it.setDocComment(field.getDocComment());
                    if (hasNonNull) {
                        MutableParameterDeclaration parameter = (MutableParameterDeclaration)IterableExtensions.head((Iterable)it.getParameters());
                        parameter.addAnnotation(context.newAnnotationReference(NonNull.class));
                        StringConcatenationClient _client = new StringConcatenationClient((MutableFieldDeclaration)field, impl, context, parameter){
                            final /* synthetic */ MutableFieldDeclaration val$field;
                            final /* synthetic */ MutableClassDeclaration val$impl;
                            final /* synthetic */ JsonRpcDataTransformationContext val$context;
                            final /* synthetic */ MutableParameterDeclaration val$parameter;
                            {
                                this.val$field = mutableFieldDeclaration;
                                this.val$impl = mutableClassDeclaration;
                                this.val$context = jsonRpcDataTransformationContext;
                                this.val$parameter = mutableParameterDeclaration;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"this.");
                                String _simpleName = this.val$field.getSimpleName();
                                _builder.append((Object)_simpleName);
                                _builder.append((Object)" = ");
                                TypeReference _preconditionsUtil = JsonRpcDataProcessor.this.getPreconditionsUtil((Type)this.val$impl, this.val$context);
                                _builder.append((Object)_preconditionsUtil);
                                _builder.append((Object)".checkNotNull(");
                                String _simpleName_1 = this.val$parameter.getSimpleName();
                                _builder.append((Object)_simpleName_1);
                                _builder.append((Object)", \"");
                                String _simpleName_2 = this.val$field.getSimpleName();
                                _builder.append((Object)_simpleName_2);
                                _builder.append((Object)"\");");
                                _builder.newLineIfNotEmpty();
                            }
                        };
                        it.setBody(_client);
                    }
                    if (deprecated != null) {
                        it.addAnnotation(context.newAnnotationReference(Deprecated.class));
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_findDeclaredMethod_1, (Procedures.Procedure1)_function_3);
                Collection<EitherTypeArgument> childTypes = context.getChildTypes(field.getType());
                boolean _isEmpty = childTypes.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty;
                if (_not_1) {
                    int _size_1;
                    boolean _tripleNotEquals;
                    Functions.Function1 _function_4 = it -> context.getJsonType(it.getType());
                    List jsonTypes = IterableExtensions.toList((Iterable)IterableExtensions.map(childTypes, (Functions.Function1)_function_4));
                    int _size = jsonTypes.size();
                    boolean bl3 = _tripleNotEquals = _size != (_size_1 = IterableExtensions.toSet((Iterable)jsonTypes).size());
                    if (_tripleNotEquals) {
                        if (!hasJsonAdapter) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("The json types of an Either must be distinct.");
                            context.addWarning((Element)field, _builder.toString());
                        }
                    } else {
                        for (EitherTypeArgument childType : childTypes) {
                            this.addEitherSetter((MutableFieldDeclaration)field, setterName, childType, context);
                        }
                    }
                }
            }
        };
        IterableExtensions.filter((Iterable)impl.getDeclaredFields(), (Functions.Function1)_function).forEach(_function_1);
    }

    protected void addEitherSetter(MutableFieldDeclaration field, String setterName, EitherTypeArgument argument, @Extension JsonRpcDataTransformationContext context) {
        Procedures.Procedure1 _function = method -> {
            context.setPrimarySourceElement((MutableElement)method, context.getPrimarySourceElement((Element)field));
            method.addParameter(field.getSimpleName(), argument.getType());
            method.setStatic(field.isStatic());
            method.setVisibility(Visibility.PUBLIC);
            method.setReturnType(context.getPrimitiveVoid());
            CompilationStrategy _function_1 = ctx -> this.compileEitherSetterBody(field, argument, field.getSimpleName(), ctx, context);
            method.setBody(_function_1);
        };
        field.getDeclaringType().addMethod(setterName, _function);
    }

    protected CharSequence compileEitherSetterBody(MutableFieldDeclaration field, EitherTypeArgument argument, String variableName, @Extension CompilationStrategy.CompilationContext compilationContext, @Extension JsonRpcDataTransformationContext context) {
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        AnnotationReference _findAnnotation = field.findAnnotation(context.newTypeReference(NonNull.class, new TypeReference[0]).getType());
        boolean hasNonNull = _findAnnotation != null;
        String newVariableName = "_" + variableName;
        StringConcatenation _builder = new StringConcatenation();
        String _javaCode = compilationContext.toJavaCode(context.getEitherType());
        _builder.append(_javaCode);
        _builder.append(".for");
        boolean _isRight = argument.isRight();
        if (_isRight) {
            _builder.append("Right");
        } else {
            _builder.append("Left");
        }
        _builder.append("(");
        _builder.append(variableName);
        _builder.append(")");
        StringConcatenation compileNewEither = _builder;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("if (");
        _builder_1.append(variableName);
        _builder_1.append(" == null) {");
        _builder_1.newLineIfNotEmpty();
        if (hasNonNull) {
            _builder_1.append("  ");
            TypeReference _preconditionsUtil = this.getPreconditionsUtil((Type)field.getDeclaringType(), context);
            _builder_1.append((Object)_preconditionsUtil, "  ");
            _builder_1.append(".checkNotNull(");
            _builder_1.append(variableName, "  ");
            _builder_1.append(", \"");
            String _simpleName = field.getSimpleName();
            _builder_1.append(_simpleName, "  ");
            _builder_1.append("\");");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("  ");
        _builder_1.append("this.");
        String _simpleName_1 = field.getSimpleName();
        _builder_1.append(_simpleName_1, "  ");
        _builder_1.append(" = null;");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("  ");
        _builder_1.append("return;");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        EitherTypeArgument _parent = argument.getParent();
        boolean bl = _tripleNotEquals = _parent != null;
        if (_tripleNotEquals) {
            _builder_1.append("final ");
            String _javaCode_1 = compilationContext.toJavaCode(argument.getParent().getType());
            _builder_1.append(_javaCode_1);
            _builder_1.append(" ");
            _builder_1.append(newVariableName);
            _builder_1.append(" = ");
            _builder_1.append((Object)compileNewEither);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            CharSequence _compileEitherSetterBody = this.compileEitherSetterBody(field, argument.getParent(), newVariableName, compilationContext, context);
            _builder_1.append((Object)_compileEitherSetterBody);
            _builder_1.newLineIfNotEmpty();
        } else {
            _builder_1.append("this.");
            String _simpleName_2 = field.getSimpleName();
            _builder_1.append(_simpleName_2);
            _builder_1.append(" = ");
            _builder_1.append((Object)compileNewEither);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
        }
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    protected MutableMethodDeclaration generateToString(final MutableClassDeclaration impl, @Extension TransformationContext context) {
        Type _type;
        MutableMethodDeclaration _xblockexpression = null;
        final ArrayList toStringFields = CollectionLiterals.newArrayList();
        MutableClassDeclaration c = impl;
        do {
            Iterable _declaredFields = c.getDeclaredFields();
            Iterables.addAll((Collection)toStringFields, (Iterable)_declaredFields);
            TypeReference _extendedClass = c.getExtendedClass();
            _type = null;
            if (_extendedClass == null) continue;
            _type = _extendedClass.getType();
        } while ((c = (ClassDeclaration)_type) != null && !Objects.equal((Object)c, (Object)context.getObject()));
        Procedures.Procedure1 _function = it -> {
            it.setReturnType(context.getString());
            it.addAnnotation(context.newAnnotationReference(Override.class));
            final AccessorsProcessor.Util accessorsUtil = new AccessorsProcessor.Util(context);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(MoreObjects.ToStringHelper.class);
                    _builder.append((Object)" b = ");
                    _builder.append(MoreObjects.class);
                    _builder.append((Object)".toStringHelper(this);");
                    _builder.newLineIfNotEmpty();
                    for (FieldDeclaration field : toStringFields) {
                        _builder.append((Object)"b.add(\"");
                        String _simpleName = field.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)"\", ");
                        TypeDeclaration _declaringType = field.getDeclaringType();
                        boolean _equals = Objects.equal((Object)_declaringType, (Object)impl);
                        if (_equals) {
                            _builder.append((Object)"this.");
                            String _simpleName_1 = field.getSimpleName();
                            _builder.append((Object)_simpleName_1);
                        } else {
                            String _getterName = accessorsUtil.getGetterName(field);
                            _builder.append((Object)_getterName);
                            _builder.append((Object)"()");
                        }
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"return b.toString();");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        _xblockexpression = impl.addMethod("toString", _function);
        return _xblockexpression;
    }

    private TypeReference getPreconditionsUtil(Type type, @Extension TransformationContext context) {
        TypeReference _xifexpression = null;
        boolean _startsWith = type.getQualifiedName().startsWith("org.eclipse.lsp4j.debug");
        _xifexpression = _startsWith ? context.newTypeReference("org.eclipse.lsp4j.debug.util.Preconditions", new TypeReference[0]) : context.newTypeReference("org.eclipse.lsp4j.util.Preconditions", new TypeReference[0]);
        return _xifexpression;
    }
}

