/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import com.google.common.base.MoreObjects;
import com.google.gson.annotations.JsonAdapter;
import org.eclipse.lsp4j.adapters.ResourceOperationTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4j.util.Preconditions;

@JsonAdapter(ResourceOperationTypeAdapter.class)
@SuppressWarnings("all")
public abstract class ResourceOperation {
  /**
   * The kind of resource operation. For allowed values, see {@link ResourceOperationKind}
   */
  @NonNull
  private String kind;

  /**
   * An optional annotation identifier describing the operation.
   * <p>
   * Since 3.16.0
   */
  private String annotationId;

  public ResourceOperation() {
  }

  public ResourceOperation(@NonNull final String kind) {
    this.kind = Preconditions.<String>checkNotNull(kind, "kind");
  }

  /**
   * The kind of resource operation. For allowed values, see {@link ResourceOperationKind}
   */
  @NonNull
  public String getKind() {
    return this.kind;
  }

  /**
   * The kind of resource operation. For allowed values, see {@link ResourceOperationKind}
   */
  public void setKind(@NonNull final String kind) {
    this.kind = Preconditions.checkNotNull(kind, "kind");
  }

  /**
   * An optional annotation identifier describing the operation.
   * <p>
   * Since 3.16.0
   */
  public String getAnnotationId() {
    return this.annotationId;
  }

  /**
   * An optional annotation identifier describing the operation.
   * <p>
   * Since 3.16.0
   */
  public void setAnnotationId(final String annotationId) {
    this.annotationId = annotationId;
  }

  @Override
  public String toString() {
    MoreObjects.ToStringHelper b = MoreObjects.toStringHelper(this);
    b.add("kind", this.kind);
    b.add("annotationId", this.annotationId);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ResourceOperation other = (ResourceOperation) obj;
    if (this.kind == null) {
      if (other.kind != null)
        return false;
    } else if (!this.kind.equals(other.kind))
      return false;
    if (this.annotationId == null) {
      if (other.annotationId != null)
        return false;
    } else if (!this.annotationId.equals(other.annotationId))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.kind== null) ? 0 : this.kind.hashCode());
    return prime * result + ((this.annotationId== null) ? 0 : this.annotationId.hashCode());
  }
}
