/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import com.google.common.base.MoreObjects;

@SuppressWarnings("all")
public class DynamicRegistrationCapabilities {
  /**
   * Supports dynamic registration.
   */
  private Boolean dynamicRegistration;

  public DynamicRegistrationCapabilities() {
  }

  public DynamicRegistrationCapabilities(final Boolean dynamicRegistration) {
    this.dynamicRegistration = dynamicRegistration;
  }

  /**
   * Supports dynamic registration.
   */
  public Boolean getDynamicRegistration() {
    return this.dynamicRegistration;
  }

  /**
   * Supports dynamic registration.
   */
  public void setDynamicRegistration(final Boolean dynamicRegistration) {
    this.dynamicRegistration = dynamicRegistration;
  }

  @Override
  public String toString() {
    MoreObjects.ToStringHelper b = MoreObjects.toStringHelper(this);
    b.add("dynamicRegistration", this.dynamicRegistration);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    DynamicRegistrationCapabilities other = (DynamicRegistrationCapabilities) obj;
    if (this.dynamicRegistration == null) {
      if (other.dynamicRegistration != null)
        return false;
    } else if (!this.dynamicRegistration.equals(other.dynamicRegistration))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.dynamicRegistration== null) ? 0 : this.dynamicRegistration.hashCode());
  }
}
