/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import com.google.common.annotations.Beta;
import org.eclipse.lsp4j.MarkdownCapabilities;
import org.eclipse.lsp4j.RegularExpressionsCapabilities;
import org.eclipse.lsp4j.StaleRequestCapabilities;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * General client capabilities.
 * <p>
 * Since 3.16.0
 */
@SuppressWarnings("all")
public class GeneralClientCapabilities {
  /**
   * Client capabilities specific to regular expressions.
   * <p>
   * Since 3.16.0
   */
  private RegularExpressionsCapabilities regularExpressions;
  
  /**
   * Client capabilities specific to the client's markdown parser.
   * <p>
   * Since 3.16.0
   */
  private MarkdownCapabilities markdown;
  
  /**
   * Client capability that signals how the client handles stale requests
   * (e.g. a request for which the client will not process the response
   * anymore since the information is outdated).
   * <p>
   * Since 3.17.0
   */
  @Beta
  private StaleRequestCapabilities staleRequestSupport;
  
  /**
   * Client capabilities specific to regular expressions.
   * <p>
   * Since 3.16.0
   */
  @Pure
  public RegularExpressionsCapabilities getRegularExpressions() {
    return this.regularExpressions;
  }
  
  /**
   * Client capabilities specific to regular expressions.
   * <p>
   * Since 3.16.0
   */
  public void setRegularExpressions(final RegularExpressionsCapabilities regularExpressions) {
    this.regularExpressions = regularExpressions;
  }
  
  /**
   * Client capabilities specific to the client's markdown parser.
   * <p>
   * Since 3.16.0
   */
  @Pure
  public MarkdownCapabilities getMarkdown() {
    return this.markdown;
  }
  
  /**
   * Client capabilities specific to the client's markdown parser.
   * <p>
   * Since 3.16.0
   */
  public void setMarkdown(final MarkdownCapabilities markdown) {
    this.markdown = markdown;
  }
  
  /**
   * Client capability that signals how the client handles stale requests
   * (e.g. a request for which the client will not process the response
   * anymore since the information is outdated).
   * <p>
   * Since 3.17.0
   */
  @Pure
  public StaleRequestCapabilities getStaleRequestSupport() {
    return this.staleRequestSupport;
  }
  
  /**
   * Client capability that signals how the client handles stale requests
   * (e.g. a request for which the client will not process the response
   * anymore since the information is outdated).
   * <p>
   * Since 3.17.0
   */
  public void setStaleRequestSupport(final StaleRequestCapabilities staleRequestSupport) {
    this.staleRequestSupport = staleRequestSupport;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("regularExpressions", this.regularExpressions);
    b.add("markdown", this.markdown);
    b.add("staleRequestSupport", this.staleRequestSupport);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    GeneralClientCapabilities other = (GeneralClientCapabilities) obj;
    if (this.regularExpressions == null) {
      if (other.regularExpressions != null)
        return false;
    } else if (!this.regularExpressions.equals(other.regularExpressions))
      return false;
    if (this.markdown == null) {
      if (other.markdown != null)
        return false;
    } else if (!this.markdown.equals(other.markdown))
      return false;
    if (this.staleRequestSupport == null) {
      if (other.staleRequestSupport != null)
        return false;
    } else if (!this.staleRequestSupport.equals(other.staleRequestSupport))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.regularExpressions== null) ? 0 : this.regularExpressions.hashCode());
    result = prime * result + ((this.markdown== null) ? 0 : this.markdown.hashCode());
    return prime * result + ((this.staleRequestSupport== null) ? 0 : this.staleRequestSupport.hashCode());
  }
}
