/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import java.util.Map;
import org.eclipse.lsp4j.debug.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Arguments for 'startDebugging' request.
 */
@SuppressWarnings("all")
public class StartDebuggingRequestArguments {
  /**
   * Arguments passed to the new debug session. The arguments must only contain
   * properties understood by the `launch` or `attach` requests of the debug
   * adapter and they must not contain any client-specific properties (e.g.
   * `type`) or client-specific features (e.g. substitutable 'variables').
   */
  @NonNull
  private Map<String, ?> configuration;

  /**
   * Indicates whether the new debug session should be started with a `launch`
   * or `attach` request.
   */
  @NonNull
  private StartDebuggingRequestArgumentsType request;

  /**
   * Arguments passed to the new debug session. The arguments must only contain
   * properties understood by the `launch` or `attach` requests of the debug
   * adapter and they must not contain any client-specific properties (e.g.
   * `type`) or client-specific features (e.g. substitutable 'variables').
   */
  @NonNull
  public Map<String, ?> getConfiguration() {
    return this.configuration;
  }

  /**
   * Arguments passed to the new debug session. The arguments must only contain
   * properties understood by the `launch` or `attach` requests of the debug
   * adapter and they must not contain any client-specific properties (e.g.
   * `type`) or client-specific features (e.g. substitutable 'variables').
   */
  public void setConfiguration(@NonNull final Map<String, ?> configuration) {
    this.configuration = Preconditions.checkNotNull(configuration, "configuration");
  }

  /**
   * Indicates whether the new debug session should be started with a `launch`
   * or `attach` request.
   */
  @NonNull
  public StartDebuggingRequestArgumentsType getRequest() {
    return this.request;
  }

  /**
   * Indicates whether the new debug session should be started with a `launch`
   * or `attach` request.
   */
  public void setRequest(@NonNull final StartDebuggingRequestArgumentsType request) {
    this.request = Preconditions.checkNotNull(request, "request");
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("configuration", this.configuration);
    b.add("request", this.request);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    StartDebuggingRequestArguments other = (StartDebuggingRequestArguments) obj;
    if (this.configuration == null) {
      if (other.configuration != null)
        return false;
    } else if (!this.configuration.equals(other.configuration))
      return false;
    if (this.request == null) {
      if (other.request != null)
        return false;
    } else if (!this.request.equals(other.request))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.configuration== null) ? 0 : this.configuration.hashCode());
    return prime * result + ((this.request== null) ? 0 : this.request.hashCode());
  }
}
