/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.websocket;

import java.util.Collection;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueHandler;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.websocket.WebSocketMessageConsumer;
import org.eclipse.lsp4j.websocket.WebSocketMessageHandler;

public class WebSocketLauncherBuilder<T>
extends Launcher.Builder<T> {
    protected Session session;

    public Collection<Object> getLocalServices() {
        return this.localServices;
    }

    public WebSocketLauncherBuilder<T> setSession(Session session) {
        this.session = session;
        return this;
    }

    public Launcher<T> create() {
        if (this.localServices == null) {
            throw new IllegalStateException("Local service must be configured.");
        }
        if (this.remoteInterfaces == null) {
            throw new IllegalStateException("Remote interface must be configured.");
        }
        MessageJsonHandler jsonHandler = this.createJsonHandler();
        if (this.messageTracer != null) {
            this.messageTracer.setJsonHandler(jsonHandler);
        }
        RemoteEndpoint remoteEndpoint = this.createRemoteEndpoint(jsonHandler);
        this.addMessageHandlers(jsonHandler, remoteEndpoint);
        Object remoteProxy = this.createProxy(remoteEndpoint);
        return this.createLauncher(null, remoteProxy, remoteEndpoint, null);
    }

    protected RemoteEndpoint createRemoteEndpoint(MessageJsonHandler jsonHandler) {
        WebSocketMessageConsumer outgoingMessageStream = new WebSocketMessageConsumer(this.session, jsonHandler);
        outgoingMessageStream = this.wrapMessageConsumer(outgoingMessageStream);
        Endpoint localEndpoint = ServiceEndpoints.toEndpoint((Collection)this.localServices);
        RemoteEndpoint remoteEndpoint = this.exceptionHandler == null ? new RemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint) : new RemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint, this.exceptionHandler);
        jsonHandler.setMethodProvider((MethodProvider)remoteEndpoint);
        remoteEndpoint.setJsonHandler(jsonHandler);
        return remoteEndpoint;
    }

    protected void addMessageHandlers(MessageJsonHandler jsonHandler, RemoteEndpoint remoteEndpoint) {
        MessageConsumer messageConsumer = this.wrapMessageConsumer((MessageConsumer)remoteEndpoint);
        this.session.addMessageHandler((MessageHandler)new WebSocketMessageHandler(messageConsumer, jsonHandler, (MessageIssueHandler)remoteEndpoint));
    }
}

