/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import java.util.List;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4j.util.Preconditions;

public class DocumentSymbol {
    @NonNull
    private String name;
    @NonNull
    private SymbolKind kind;
    @NonNull
    private Range range;
    @NonNull
    private Range selectionRange;
    private String detail;
    private List<SymbolTag> tags;
    @Deprecated
    private Boolean deprecated;
    private List<DocumentSymbol> children;

    public DocumentSymbol() {
    }

    public DocumentSymbol(@NonNull String name, @NonNull SymbolKind kind, @NonNull Range range, @NonNull Range selectionRange) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.kind = Preconditions.checkNotNull(kind, "kind");
        this.range = Preconditions.checkNotNull(range, "range");
        this.selectionRange = Preconditions.checkNotNull(selectionRange, "selectionRange");
    }

    public DocumentSymbol(@NonNull String name, @NonNull SymbolKind kind, @NonNull Range range, @NonNull Range selectionRange, String detail) {
        this(name, kind, range, selectionRange);
        this.detail = detail;
    }

    public DocumentSymbol(@NonNull String name, @NonNull SymbolKind kind, @NonNull Range range, @NonNull Range selectionRange, String detail, List<DocumentSymbol> children) {
        this(name, kind, range, selectionRange);
        this.detail = detail;
        this.children = children;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = Preconditions.checkNotNull(name, "name");
    }

    @NonNull
    public SymbolKind getKind() {
        return this.kind;
    }

    public void setKind(@NonNull SymbolKind kind) {
        this.kind = Preconditions.checkNotNull(kind, "kind");
    }

    @NonNull
    public Range getRange() {
        return this.range;
    }

    public void setRange(@NonNull Range range) {
        this.range = Preconditions.checkNotNull(range, "range");
    }

    @NonNull
    public Range getSelectionRange() {
        return this.selectionRange;
    }

    public void setSelectionRange(@NonNull Range selectionRange) {
        this.selectionRange = Preconditions.checkNotNull(selectionRange, "selectionRange");
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public List<SymbolTag> getTags() {
        return this.tags;
    }

    public void setTags(List<SymbolTag> tags) {
        this.tags = tags;
    }

    @Deprecated
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Deprecated
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public List<DocumentSymbol> getChildren() {
        return this.children;
    }

    public void setChildren(List<DocumentSymbol> children) {
        this.children = children;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.name);
        b.add("kind", (Object)this.kind);
        b.add("range", (Object)this.range);
        b.add("selectionRange", (Object)this.selectionRange);
        b.add("detail", (Object)this.detail);
        b.add("tags", this.tags);
        b.add("deprecated", (Object)this.deprecated);
        b.add("children", this.children);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentSymbol other = (DocumentSymbol)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.kind == null ? other.kind != null : !this.kind.equals((Object)other.kind)) {
            return false;
        }
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        if (this.selectionRange == null ? other.selectionRange != null : !this.selectionRange.equals(other.selectionRange)) {
            return false;
        }
        if (this.detail == null ? other.detail != null : !this.detail.equals(other.detail)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        if (this.deprecated == null ? other.deprecated != null : !this.deprecated.equals(other.deprecated)) {
            return false;
        }
        return !(this.children == null ? other.children != null : !this.children.equals(other.children));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.selectionRange == null ? 0 : this.selectionRange.hashCode());
        result = 31 * result + (this.detail == null ? 0 : this.detail.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.deprecated == null ? 0 : this.deprecated.hashCode());
        return 31 * result + (this.children == null ? 0 : this.children.hashCode());
    }
}

