/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import com.google.gson.annotations.JsonAdapter;
import java.util.List;
import org.eclipse.lsp4j.InlayHintKind;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.json.adapters.JsonElementTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4j.util.Preconditions;

public class InlayHint {
    @NonNull
    private Position position;
    @NonNull
    private Either<String, List<InlayHintLabelPart>> label;
    private InlayHintKind kind;
    private List<TextEdit> textEdits;
    private Either<String, MarkupContent> tooltip;
    private Boolean paddingLeft;
    private Boolean paddingRight;
    @JsonAdapter(value=JsonElementTypeAdapter.Factory.class)
    private Object data;

    public InlayHint() {
    }

    public InlayHint(@NonNull Position position, @NonNull Either<String, List<InlayHintLabelPart>> label) {
        this.position = Preconditions.checkNotNull(position, "position");
        this.label = Preconditions.checkNotNull(label, "label");
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(@NonNull Position position) {
        this.position = Preconditions.checkNotNull(position, "position");
    }

    @NonNull
    public Either<String, List<InlayHintLabelPart>> getLabel() {
        return this.label;
    }

    public void setLabel(@NonNull Either<String, List<InlayHintLabelPart>> label) {
        this.label = Preconditions.checkNotNull(label, "label");
    }

    public void setLabel(String label) {
        if (label == null) {
            Preconditions.checkNotNull(label, "label");
            this.label = null;
            return;
        }
        this.label = Either.forLeft((Object)label);
    }

    public void setLabel(List<InlayHintLabelPart> label) {
        if (label == null) {
            Preconditions.checkNotNull(label, "label");
            this.label = null;
            return;
        }
        this.label = Either.forRight(label);
    }

    public InlayHintKind getKind() {
        return this.kind;
    }

    public void setKind(InlayHintKind kind) {
        this.kind = kind;
    }

    public List<TextEdit> getTextEdits() {
        return this.textEdits;
    }

    public void setTextEdits(List<TextEdit> textEdits) {
        this.textEdits = textEdits;
    }

    public Either<String, MarkupContent> getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(Either<String, MarkupContent> tooltip) {
        this.tooltip = tooltip;
    }

    public void setTooltip(String tooltip) {
        if (tooltip == null) {
            this.tooltip = null;
            return;
        }
        this.tooltip = Either.forLeft((Object)tooltip);
    }

    public void setTooltip(MarkupContent tooltip) {
        if (tooltip == null) {
            this.tooltip = null;
            return;
        }
        this.tooltip = Either.forRight((Object)tooltip);
    }

    public Boolean getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(Boolean paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public Boolean getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(Boolean paddingRight) {
        this.paddingRight = paddingRight;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("position", (Object)this.position);
        b.add("label", this.label);
        b.add("kind", (Object)this.kind);
        b.add("textEdits", this.textEdits);
        b.add("tooltip", this.tooltip);
        b.add("paddingLeft", (Object)this.paddingLeft);
        b.add("paddingRight", (Object)this.paddingRight);
        b.add("data", this.data);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InlayHint other = (InlayHint)obj;
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.kind == null ? other.kind != null : !this.kind.equals((Object)other.kind)) {
            return false;
        }
        if (this.textEdits == null ? other.textEdits != null : !this.textEdits.equals(other.textEdits)) {
            return false;
        }
        if (this.tooltip == null ? other.tooltip != null : !this.tooltip.equals(other.tooltip)) {
            return false;
        }
        if (this.paddingLeft == null ? other.paddingLeft != null : !this.paddingLeft.equals(other.paddingLeft)) {
            return false;
        }
        if (this.paddingRight == null ? other.paddingRight != null : !this.paddingRight.equals(other.paddingRight)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.textEdits == null ? 0 : this.textEdits.hashCode());
        result = 31 * result + (this.tooltip == null ? 0 : this.tooltip.hashCode());
        result = 31 * result + (this.paddingLeft == null ? 0 : this.paddingLeft.hashCode());
        result = 31 * result + (this.paddingRight == null ? 0 : this.paddingRight.hashCode());
        return 31 * result + (this.data == null ? 0 : this.data.hashCode());
    }
}

