/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.RenameFileOptions;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4j.util.Preconditions;

public class RenameFile
extends ResourceOperation {
    @NonNull
    private String oldUri;
    @NonNull
    private String newUri;
    private RenameFileOptions options;

    public RenameFile() {
        super("rename");
    }

    public RenameFile(@NonNull String oldUri, @NonNull String newUri) {
        super("rename");
        this.oldUri = Preconditions.checkNotNull(oldUri, "oldUri");
        this.newUri = Preconditions.checkNotNull(newUri, "newUri");
    }

    public RenameFile(@NonNull String oldUri, @NonNull String newUri, RenameFileOptions options) {
        this(oldUri, newUri);
        this.options = options;
    }

    @NonNull
    public String getOldUri() {
        return this.oldUri;
    }

    public void setOldUri(@NonNull String oldUri) {
        this.oldUri = Preconditions.checkNotNull(oldUri, "oldUri");
    }

    @NonNull
    public String getNewUri() {
        return this.newUri;
    }

    public void setNewUri(@NonNull String newUri) {
        this.newUri = Preconditions.checkNotNull(newUri, "newUri");
    }

    public RenameFileOptions getOptions() {
        return this.options;
    }

    public void setOptions(RenameFileOptions options) {
        this.options = options;
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("oldUri", (Object)this.oldUri);
        b.add("newUri", (Object)this.newUri);
        b.add("options", (Object)this.options);
        b.add("kind", (Object)this.getKind());
        b.add("annotationId", (Object)this.getAnnotationId());
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RenameFile other = (RenameFile)obj;
        if (this.oldUri == null ? other.oldUri != null : !this.oldUri.equals(other.oldUri)) {
            return false;
        }
        if (this.newUri == null ? other.newUri != null : !this.newUri.equals(other.newUri)) {
            return false;
        }
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.oldUri == null ? 0 : this.oldUri.hashCode());
        result = 31 * result + (this.newUri == null ? 0 : this.newUri.hashCode());
        return 31 * result + (this.options == null ? 0 : this.options.hashCode());
    }
}

