/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.util;

import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.util.Positions;
import org.eclipse.lsp4j.util.Preconditions;

public final class Ranges {
    public static boolean containsRange(Range bigger, Range smaller) {
        Preconditions.checkNotNull(bigger, "bigger");
        Preconditions.checkNotNull(smaller, "smaller");
        return Ranges.containsPosition(bigger, smaller.getStart()) && Ranges.containsPosition(bigger, smaller.getEnd());
    }

    public static boolean containsPosition(Range range, Position position) {
        Preconditions.checkNotNull(range, "range");
        Preconditions.checkNotNull(position, "position");
        return range.getStart().equals(position) || Positions.isBefore(range.getStart(), position) && (range.getEnd().equals(position) || Positions.isBefore(position, range.getEnd()));
    }

    private Ranges() {
    }
}

