/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.lsp4j.jsonrpc.json.InvalidMessageException;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;

public class MessageJsonHandler {
    private final JsonParser jsonParser = new JsonParser();
    private final Gson gson;
    private final Map<String, JsonRpcMethod> supportedMethods;
    private MethodProvider methodProvider;

    public static GsonBuilder getDefaultGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
    }

    public MessageJsonHandler(Map<String, JsonRpcMethod> supportedMethods) {
        this(MessageJsonHandler.getDefaultGsonBuilder().create(), supportedMethods);
    }

    public MessageJsonHandler(Gson gson, Map<String, JsonRpcMethod> supportedMethods) {
        this.gson = gson;
        this.supportedMethods = supportedMethods;
    }

    public void setMethodProvider(MethodProvider methodProvider) {
        this.methodProvider = methodProvider;
    }

    public Message parseMessage(CharSequence input) {
        return this.parseMessage(new StringReader(input.toString()));
    }

    public Message parseMessage(Reader input) {
        Message result;
        JsonObject json = this.jsonParser.parse(input).getAsJsonObject();
        JsonElement idElement = json.get("id");
        JsonElement methodElement = json.get("method");
        if (idElement != null && methodElement != null) {
            result = this.parseRequest(json, idElement.getAsString(), methodElement.getAsString());
        } else if (idElement != null && (json.get("result") != null || json.get("error") != null)) {
            result = this.parseResponse(json, idElement.getAsString());
        } else if (methodElement != null) {
            result = this.parseNotification(json, methodElement.getAsString());
        } else {
            throw new IllegalStateException("Unknown message " + json);
        }
        JsonElement jsonRpcElement = json.get("jsonrpc");
        if (jsonRpcElement != null) {
            result.setJsonrpc(jsonRpcElement.getAsString());
        }
        return result;
    }

    protected RequestMessage parseRequest(JsonObject json, String requestId, String method) {
        try {
            RequestMessage result = new RequestMessage();
            result.setId(requestId);
            result.setMethod(method);
            JsonElement paramsElement = json.get("params");
            if (paramsElement != null) {
                Type paramType = null;
                JsonRpcMethod jsonRpcMethod = this.supportedMethods.get(method);
                if (jsonRpcMethod != null) {
                    paramType = jsonRpcMethod.getParameterType();
                }
                result.setParams(this.fromJson(paramsElement, paramType));
            }
            return result;
        }
        catch (Exception e) {
            throw new InvalidMessageException("Could not parse request: " + e.getMessage(), json, requestId, e);
        }
    }

    protected Object fromJson(JsonElement json, Type type) {
        return this.gson.fromJson(json, (Type)(type != null ? type : Object.class));
    }

    protected ResponseMessage parseResponse(JsonObject json, String responseId) {
        if (this.methodProvider == null) {
            throw new IllegalStateException("Response methods are not accepted.");
        }
        try {
            ResponseMessage result = new ResponseMessage();
            result.setId(responseId);
            JsonElement resultElem = json.get("result");
            if (resultElem != null) {
                Type resultType = null;
                JsonRpcMethod jsonRpcMethod = this.supportedMethods.get(this.methodProvider.resolveMethod(responseId));
                if (jsonRpcMethod != null) {
                    resultType = jsonRpcMethod.getReturnType();
                }
                result.setResult(this.fromJson(resultElem, resultType));
            } else {
                JsonElement errorElement = json.get("error");
                if (errorElement != null) {
                    result.setError((ResponseError)this.gson.fromJson(errorElement, ResponseError.class));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new InvalidMessageException("Could not parse response: " + e.getMessage(), json, responseId, e);
        }
    }

    protected NotificationMessage parseNotification(JsonObject json, String method) {
        try {
            NotificationMessage result = new NotificationMessage();
            result.setMethod(method);
            JsonElement paramsElement = json.get("params");
            if (paramsElement != null) {
                Type paramType = null;
                JsonRpcMethod jsonRpcMethod = this.supportedMethods.get(method);
                if (jsonRpcMethod != null) {
                    paramType = jsonRpcMethod.getParameterType();
                }
                result.setParams(this.fromJson(paramsElement, paramType));
            }
            return result;
        }
        catch (Exception e) {
            throw new InvalidMessageException("Could not parse notification: " + e.getMessage(), json, null, e);
        }
    }

    public String serialize(Message message) {
        StringWriter writer = new StringWriter();
        this.serialize(message, writer);
        return writer.toString();
    }

    public void serialize(Message message, Writer output) {
        if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            try {
                output.append("{\"id\":" + responseMessage.getId());
                output.append(",\"jsonrpc\":" + responseMessage.getJsonrpc());
                if (responseMessage.getError() != null) {
                    output.append(",\"error\":");
                    this.gson.toJson((Object)responseMessage.getError(), (Appendable)output);
                } else {
                    output.append(",\"result\":");
                    this.gson.toJson(responseMessage.getResult(), (Appendable)output);
                }
                output.append("}");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.gson.toJson((Object)message, (Appendable)output);
        }
    }
}

