/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.ConcurrentMessageProcessor;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.jsonrpc.validation.ReflectiveMessageValidator;

public interface Launcher<T> {
    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out) {
        return Launcher.createLauncher(localService, remoteInterface, in, out, false, null);
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, boolean validate, PrintWriter trace) {
        Function<MessageConsumer, MessageConsumer> wrapper = consumer -> {
            MessageConsumer result = consumer;
            if (trace != null) {
                result = message -> {
                    trace.println(message);
                    consumer.consume(message);
                };
            }
            if (validate) {
                result = new ReflectiveMessageValidator(result);
            }
            return result;
        };
        return Launcher.createIoLauncher(localService, remoteInterface, in, out, Executors.newCachedThreadPool(), wrapper);
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return Launcher.createIoLauncher(localService, remoteInterface, in, out, executorService, wrapper);
    }

    public static <T> Launcher<T> createIoLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, final ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        LinkedHashMap<String, JsonRpcMethod> supportedMethods = new LinkedHashMap<String, JsonRpcMethod>();
        supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(remoteInterface));
        if (localService instanceof JsonRpcMethodProvider) {
            JsonRpcMethodProvider rpcMethodProvider = (JsonRpcMethodProvider)localService;
            supportedMethods.putAll(rpcMethodProvider.supportedMethods());
        } else {
            supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(localService.getClass()));
        }
        MessageJsonHandler jsonHandler = new MessageJsonHandler(supportedMethods);
        MessageConsumer outGoingMessageStream = new StreamMessageConsumer(out, jsonHandler);
        outGoingMessageStream = wrapper.apply(outGoingMessageStream);
        RemoteEndpoint serverEndpoint = new RemoteEndpoint(outGoingMessageStream, ServiceEndpoints.toEndpoint(localService));
        jsonHandler.setMethodProvider(serverEndpoint);
        final MessageConsumer messageConsumer = wrapper.apply(serverEndpoint);
        final StreamMessageProducer reader = new StreamMessageProducer(in, jsonHandler);
        final T remoteProxy = ServiceEndpoints.toServiceObject(serverEndpoint, remoteInterface);
        return new Launcher<T>(){

            @Override
            public Future<?> startListening() {
                return ConcurrentMessageProcessor.startProcessing(reader, messageConsumer, executorService);
            }

            @Override
            public T getRemoteProxy() {
                return remoteProxy;
            }
        };
    }

    public Future<?> startListening();

    public T getRemoteProxy();
}

