/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.IPDEBuildConstants;

public class FetchTaskFactoriesRegistry
implements IPDEBuildConstants {
    private final Map<String, IConfigurationElement> factories = new HashMap<String, IConfigurationElement>();
    private final Map<String, IFetchFactory> cache = new HashMap<String, IFetchFactory>();

    public FetchTaskFactoriesRegistry() {
        this.initializeRegistry();
    }

    public IFetchFactory getFactory(String id) {
        IFetchFactory result = this.cache.get(id);
        if (result != null) {
            return result;
        }
        IFetchFactory toCache = this.newFactory(id);
        if (toCache != null) {
            this.cache.put(id, toCache);
            return toCache;
        }
        return null;
    }

    public IFetchFactory newFactory(String id) {
        IConfigurationElement extension = this.factories.get(id);
        if (extension != null) {
            try {
                IFetchFactory factory = (IFetchFactory)extension.createExecutableExtension("class");
                return factory;
            }
            catch (CoreException e) {
                BundleHelper.getDefault().getLog().log(e.getStatus());
            }
        }
        return null;
    }

    public Collection<String> getFactoryIds() {
        return this.factories.keySet();
    }

    private void initializeRegistry() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.build.fetchFactories");
        int i = 0;
        while (i < extensions.length) {
            String id;
            IConfigurationElement extension = extensions[i];
            if ("factory".equals(extension.getName()) && (id = extension.getAttribute("id")) != null && id.trim().length() > 0) {
                this.factories.put(id, extension);
            }
            ++i;
        }
    }
}

