/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.proposals.patterns;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.views.proposals.patterns.IAcceleoPatternProposal;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;

public class NewLetElseLetForeachType
implements IAcceleoPatternProposal {
    @Override
    public String getDescription() {
        return "[let] for all selected types";
    }

    @Override
    public Image getImage() {
        return AcceleoUIActivator.getDefault().getImage("icons/proposals/NewLetElseLetForeachType.gif");
    }

    @Override
    public boolean isEnabled(String text, int offset, EObject cstNode) {
        return cstNode instanceof TextExpression;
    }

    @Override
    public String createTemplateProposal(List<EClass> types, String indentTab) {
        Collections.sort(types, new Comparator<EClass>(){

            @Override
            public int compare(EClass c0, EClass c1) {
                if (c0.isSuperTypeOf(c1)) {
                    return 1;
                }
                return -1;
            }
        });
        StringBuilder buffer = new StringBuilder();
        if (types.size() > 0) {
            buffer.append("[let ${e} : ");
            buffer.append(types.get(0).getName());
            buffer.append(" = ${self}]\n");
            buffer.append(indentTab);
            buffer.append("\t[${e}/]\n");
            int i = 1;
            while (i < types.size()) {
                EClass eClass = types.get(i);
                buffer.append(indentTab);
                buffer.append("[elselet ${e} : ");
                buffer.append(eClass.getName());
                buffer.append(" = ${self}]\n");
                buffer.append(indentTab);
                buffer.append("\t[${e}/]\n");
                ++i;
            }
            buffer.append(indentTab);
            buffer.append("[else]\n");
            buffer.append(indentTab);
            buffer.append("\t[${e}/]\n");
            buffer.append(indentTab);
            buffer.append("[/let]");
        }
        return buffer.toString();
    }
}

