/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.workspace;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanion;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanionProvider;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;

public final class ClassLoadingCompanionsRegistry {
    public static final ClassLoadingCompanionsRegistry INSTANCE = new ClassLoadingCompanionsRegistry();
    private final Set<ClassLoadingCompanionProvider> registeredCompanions = new CompactLinkedHashSet<ClassLoadingCompanionProvider>();

    private ClassLoadingCompanionsRegistry() {
    }

    public void register(ClassLoadingCompanionProvider instance) {
        this.registeredCompanions.add(instance);
    }

    public void unregister(String className) {
        for (ClassLoadingCompanionProvider connector : this.registeredCompanions) {
            if (!className.equals(connector.getClass().getName())) continue;
            this.registeredCompanions.remove(connector);
        }
    }

    public Collection<ClassLoadingCompanion> getAllRegisteredCompanions() {
        LinkedHashSet<ClassLoadingCompanion> companions = new LinkedHashSet<ClassLoadingCompanion>();
        for (ClassLoadingCompanionProvider provider : this.registeredCompanions) {
            ClassLoadingCompanion provided = provider.getCompanion();
            if (provided == null) continue;
            companions.add(provided);
        }
        return companions;
    }

    public void clearRegistry() {
        this.registeredCompanions.clear();
    }
}

