/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.InstanceRoleGraphicalHorizontalOrderingComparator;

public abstract class AbstractInstanceRoleValidator {
    protected Map<InstanceRole, Point> moveDeltas = new HashMap<InstanceRole, Point>();
    protected InstanceRoleGraphicalHorizontalOrderingComparator comparator = new InstanceRoleGraphicalHorizontalOrderingComparator();
    protected List<InstanceRole> instanceRoles;

    public void setSequenceElements(List<InstanceRole> sequenceElements) {
        this.instanceRoles = sequenceElements;
    }

    public boolean isValid(ChangeBoundsRequest request) {
        Preconditions.checkNotNull(this.instanceRoles, (Object)Messages.AbstractInstanceRoleValidator_nullInstanceRoleList);
        return true;
    }

    protected int getDropIndex(Point locationAfterMoving, List<InstanceRole> instanceRolesToMove) {
        ListIterator<InstanceRole> iterator = instanceRolesToMove.listIterator();
        int x = 0;
        int i = 0;
        while (iterator.hasNext()) {
            InstanceRole instanceRoleEditPart = iterator.next();
            Bounds bounds = (Bounds)instanceRoleEditPart.getNotationNode().getLayoutConstraint();
            x = bounds.getX();
            if (this.moveDeltas != null && this.moveDeltas.containsKey(instanceRoleEditPart)) {
                x += this.moveDeltas.get((Object)instanceRoleEditPart).x;
            }
            if (locationAfterMoving.x <= x) {
                return i;
            }
            ++i;
        }
        return i;
    }

    protected boolean dropIndexSameAsInitialIndex(int dropIndex, InstanceRole instanceRole) {
        List<InstanceRole> allInstanceRoleEditParts = this.getOrderedMovableInstanceRoles(Collections.emptyList());
        return allInstanceRoleEditParts.indexOf(instanceRole) == dropIndex;
    }

    protected List<InstanceRole> getOrderedMovableInstanceRoles(List<InstanceRole> instanceRoleToMove) {
        ArrayList allInstanceRoles = Lists.newArrayList((Iterable)this.instanceRoles.get(0).getDiagram().getAllInstanceRoles());
        allInstanceRoles.removeAll(instanceRoleToMove);
        Collections.sort(allInstanceRoles, this.comparator);
        return allInstanceRoles;
    }

    protected void moveOverLappedAtTheRightForMoving(Rectangle boundsAfterMoving, ListIterator<InstanceRole> iteratorForRight) {
    }

    public Map<InstanceRole, Point> getMoveDeltas() {
        return this.moveDeltas;
    }
}

