/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.synchronize.GitChangeSetModelProvider;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;

public class GitChangeSetLabelProvider
extends SynchronizationLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public static final String BINDING_CHANGESET_SHORT_MESSAGE = "{short_message}";
    public static final String BINDING_CHANGESET_COMMITTER = "{committer}";
    public static final String BINDING_CHANGESET_AUTHOR = "{author}";
    public static final String BINDING_CHANGESET_DATE = "{date}";
    private GitLabelProvider delegateLabelProvider;
    private final ListenerList listeners = new ListenerList(1);
    private final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private final IPropertyChangeListener uiPrefsListener;
    private PreferenceBasedDateFormatter dateFormatter = PreferenceBasedDateFormatter.create();

    public GitChangeSetLabelProvider() {
        this.uiPrefsListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("date_format".equals(property) || "date_format_choice".equals(property)) {
                    GitChangeSetLabelProvider.this.dateFormatter = PreferenceBasedDateFormatter.create();
                    GitChangeSetLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)GitChangeSetLabelProvider.this));
                }
            }
        };
        this.store.addPropertyChangeListener(this.uiPrefsListener);
    }

    protected GitLabelProvider getDelegateLabelProvider() {
        if (this.delegateLabelProvider == null) {
            this.delegateLabelProvider = new GitLabelProvider();
        }
        return this.delegateLabelProvider;
    }

    public StyledString getStyledText(Object element) {
        if (element.getClass().equals(GitModelCommit.class)) {
            String formattedName = this.createChangeSetLabel((GitModelCommit)element);
            StyledString string = new StyledString(formattedName);
            GitModelCommit commit = (GitModelCommit)element;
            String format = " [" + this.getAbbreviatedId(commit) + "]";
            string.append(format, StyledString.DECORATIONS_STYLER);
            return string;
        }
        if (element instanceof GitChangeSetModelProvider) {
            return new StyledString(UIText.GitChangeSetModelProviderLabel);
        }
        return this.getDelegateLabelProvider().getStyledText(element);
    }

    private String createChangeSetLabel(GitModelCommit commitModel) {
        String format = this.store.getString("sync_view_changeset_pattern");
        GitCommitsModelCache.Commit commit = commitModel.getCachedCommitObj();
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put(BINDING_CHANGESET_DATE, this.dateFormatter.formatDate(commit.getCommitDate()));
        bindings.put(BINDING_CHANGESET_AUTHOR, commit.getAuthorName());
        bindings.put(BINDING_CHANGESET_COMMITTER, commit.getCommitterName());
        bindings.put(BINDING_CHANGESET_SHORT_MESSAGE, commit.getShortMessage());
        return GitChangeSetLabelProvider.formatName(format, bindings);
    }

    public static String formatName(String format, Map<String, String> bindings) {
        String result = format;
        for (Map.Entry<String, String> e : bindings.entrySet()) {
            result = result.replace(e.getKey(), e.getValue());
        }
        return result;
    }

    private String getAbbreviatedId(GitModelCommit commit) {
        AbbreviatedObjectId shortId = commit.getCachedCommitObj().getId();
        return shortId.name().substring(0, 6);
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.listeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
        super.removeListener(listener);
    }

    private void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            final ILabelProviderListener l = (ILabelProviderListener)o;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++n2;
        }
    }

    public void dispose() {
        this.store.removePropertyChangeListener(this.uiPrefsListener);
        this.listeners.clear();
        super.dispose();
    }
}

