/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.ext.base.relations.Relation;
import org.eclipse.sirius.ext.base.relations.TransitiveClosure;
import org.eclipse.sirius.ext.base.relations.UnionRelation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointRelations {
    private final ViewpointRegistry registry;
    private final Relation<URI> reuse = new AbstractViewpointDependency(this){

        @Override
        protected EList<URI> getDependencies(Viewpoint vp) {
            return vp.getReuses();
        }
    };
    private final Relation<URI> customize = new AbstractViewpointDependency(this){

        @Override
        protected EList<URI> getDependencies(Viewpoint vp) {
            return vp.getCustomizes();
        }
    };
    private final Relation<URI> conflicts = new AbstractViewpointDependency(this){

        @Override
        protected EList<URI> getDependencies(Viewpoint vp) {
            return vp.getConflicts();
        }
    };
    private final Relation<URI> transitiveRequires = new TransitiveClosure((Relation)new UnionRelation(new Relation[]{this.reuse, this.customize}));

    public ViewpointRelations(ViewpointRegistry registry) {
        this.registry = (ViewpointRegistry)Preconditions.checkNotNull((Object)registry);
    }

    public Relation<URI> getReuse() {
        return this.reuse;
    }

    public Relation<URI> getConflicts() {
        return this.conflicts;
    }

    public Relation<URI> getTransitiveRequires() {
        return this.transitiveRequires;
    }

    public Relation<URI> getCustomize() {
        return this.customize;
    }

    public Relation<URI> getRequires() {
        return new UnionRelation(new Relation[]{this.customize, this.reuse});
    }

    private abstract class AbstractViewpointDependency
    implements Relation<URI> {
        private AbstractViewpointDependency() {
        }

        public Set<URI> apply(URI from) {
            Viewpoint vp = ViewpointRelations.this.registry.getViewpoint(from);
            if (vp != null) {
                EList<URI> declared = this.getDependencies(vp);
                return ImmutableSet.copyOf((Iterable)Iterables.filter(declared, (Predicate)Predicates.notNull()));
            }
            return Collections.emptySet();
        }

        protected abstract EList<URI> getDependencies(Viewpoint var1);
    }
}

