/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirXYLayoutEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ContainerCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchBehaviorToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.RefreshSiriusElementEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ResetOriginEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.RevealElementsEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.RevealSelectedElementsEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerDropPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPropertyHandlerEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DDiagramItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.ruler.SiriusSnapToHelperUtil;
import org.eclipse.sirius.tools.api.command.SiriusCommand;

public class DDiagramEditPart
extends AbstractDDiagramEditPart {
    public static final String MODEL_ID = "Sirius";
    public static final int VISUAL_ID = 1000;

    protected void refreshBackgroundColor() {
        super.refreshBackgroundColor();
    }

    public DDiagramEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DDiagramItemSemanticEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ContainerCreationEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        CompoundEditPolicy compoundEditPolicy = new CompoundEditPolicy();
        compoundEditPolicy.addEditPolicy((EditPolicy)new RefreshSiriusElementEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new RevealElementsEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new RevealSelectedElementsEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new LaunchBehaviorToolEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new ResetOriginEditPolicy());
        if (this.getEditPolicy("ComponentEditPolicy") != null) {
            compoundEditPolicy.addEditPolicy(this.getEditPolicy("ComponentEditPolicy"));
            this.removeEditPolicy("ComponentEditPolicy");
        }
        this.installEditPolicy("ComponentEditPolicy", compoundEditPolicy);
        this.removeEditPolicy("LayoutEditPolicy");
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new AirXYLayoutEditPolicy());
        this.removeEditPolicy("DragDropPolicy");
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new SiriusContainerDropPolicy());
        this.removeEditPolicy("PropertyHandlerPolicy");
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new SiriusPropertyHandlerEditPolicy());
    }

    @Override
    public void deactivate() {
        this.deactivateLayoutingMode();
        super.deactivate();
    }

    private void deactivateLayoutingMode() {
        if (this.getModel() instanceof Diagram) {
            Diagram diagramGMF = (Diagram)this.getModel();
            try {
                DDiagram dDiagram;
                if (diagramGMF.getElement() instanceof DDiagram && (dDiagram = (DDiagram)diagramGMF.getElement()).isIsInLayoutingMode()) {
                    this.getEditingDomain().getCommandStack().execute((Command)new SetLayoutingModeCommand(this.getEditingDomain(), dDiagram, false));
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            return SiriusSnapToHelperUtil.getSnapHelper((GraphicalEditPart)this);
        }
        return super.getAdapter(key);
    }

    public static class SetLayoutingModeCommand
    extends SiriusCommand {
        private DDiagram diagram;
        private boolean layoutingModeShouldBeEnabled;

        public SetLayoutingModeCommand(TransactionalEditingDomain editingDomain, DDiagram diagram, boolean layoutingModeShouldBeEnabled) {
            super(editingDomain, Messages.SetLayoutingModeCommand_deactivateLabel);
            this.diagram = diagram;
            this.layoutingModeShouldBeEnabled = layoutingModeShouldBeEnabled;
            if (layoutingModeShouldBeEnabled) {
                this.setLabel(Messages.SetLayoutingModeCommand_activateLabel);
            }
        }

        protected void doExecute() {
            this.diagram.setIsInLayoutingMode(this.layoutingModeShouldBeEnabled);
        }
    }
}

