/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.synchronizer.ChildCreationSupport;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.TreeFactory;
import org.eclipse.sirius.tree.TreeItemStyle;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.CreatedTreeItem;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputTreeItemDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.viewpoint.RGBValues;

class TreeItemContainerChildSupport
implements ChildCreationSupport {
    private DTreeItemContainer container;
    private GlobalContext ctx;

    TreeItemContainerChildSupport(GlobalContext ctx, DTreeItemContainer container) {
        this.container = container;
        this.ctx = ctx;
    }

    public void reorderChilds(Iterable<CreatedOutput> outDesc) {
        LinkedHashMultiset subMappings = LinkedHashMultiset.create();
        HashMap outputToItem = Maps.newHashMap();
        for (CreatedOutput createdOutput : outDesc) {
            EObject createdElement = createdOutput.getCreatedElement();
            outputToItem.put(createdElement, createdOutput);
            if (!(createdElement instanceof DTreeItem)) continue;
            DTreeItem createdDTreeItem = (DTreeItem)createdElement;
            TreeItemMapping actualMapping = createdDTreeItem.getActualMapping();
            subMappings.add((Object)actualMapping);
        }
        int startIndex = 0;
        HashMap startIndexes = Maps.newHashMap();
        for (TreeItemMapping itemMapping : subMappings) {
            startIndexes.put(itemMapping, startIndex);
            startIndex += subMappings.count((Object)itemMapping);
        }
        final HashMap newIndices = Maps.newHashMap();
        for (DTreeItem treeItem : this.container.getOwnedTreeItems()) {
            CreatedOutput createdOutput;
            int index = outputToItem.size();
            TreeItemMapping itemMapping = treeItem.getActualMapping();
            if (itemMapping != null && startIndexes.containsKey(itemMapping)) {
                index = (Integer)startIndexes.get(itemMapping);
            }
            index = (createdOutput = (CreatedOutput)outputToItem.get(treeItem)) != null ? (index += createdOutput.getNewIndex()) : -1;
            newIndices.put(treeItem, index);
        }
        ECollections.sort(this.container.getOwnedTreeItems(), (Comparator)new Comparator<DTreeItem>(){

            @Override
            public int compare(DTreeItem o1, DTreeItem o2) {
                return ((Integer)newIndices.get(o1)).compareTo((Integer)newIndices.get(o2));
            }
        });
    }

    public void deleteChild(CreatedOutput outDesc) {
        ECrossReferenceAdapter xRef = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)this.container);
        this.ctx.getModelAccessor().eDelete(outDesc.getCreatedElement(), xRef);
    }

    public CreatedOutput createChild(OutputDescriptor outDesc) {
        OutputTreeItemDescriptor descriptor = (OutputTreeItemDescriptor)outDesc;
        DTreeItem dTreeItem = TreeFactory.eINSTANCE.createDTreeItem();
        dTreeItem.setActualMapping(descriptor.getMapping().getDescription());
        dTreeItem.setTarget(outDesc.getSourceElement());
        dTreeItem.getSemanticElements().add((Object)outDesc.getSourceElement());
        TreeItemStyle treeItemStyle = TreeFactory.eINSTANCE.createTreeItemStyle();
        RGBValues backgroundColor = RGBValues.DEFAULT_GRAY;
        RGBValues labelColor = RGBValues.DEFAULT_GRAY;
        treeItemStyle.setBackgroundColor(backgroundColor);
        treeItemStyle.setLabelColor(labelColor);
        dTreeItem.setOwnedStyle(treeItemStyle);
        this.container.getOwnedTreeItems().add((Object)dTreeItem);
        CreatedTreeItem newOne = new CreatedTreeItem(this.ctx, dTreeItem, descriptor);
        return newOne;
    }
}

