/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.swt.widgets.Composite;

public class SnippetPreview
extends JavaPreview {
    private ArrayList<PreviewSnippet> fSnippets = new ArrayList();

    public SnippetPreview(Map<String, String> workingValues, Composite parent) {
        super(workingValues, parent);
    }

    @Override
    protected void doFormatPreview() {
        if (this.fSnippets.isEmpty()) {
            this.fPreviewDocument.set("");
            return;
        }
        StringBuffer buffer = new StringBuffer();
        for (PreviewSnippet snippet : this.fSnippets) {
            String formattedSource;
            try {
                formattedSource = CodeFormatterUtil.format((int)snippet.kind, (String)snippet.source, (int)0, (String)"\n", (Map)this.fWorkingValues);
            }
            catch (Exception e) {
                Status status = new Status(4, JavaPlugin.getPluginId(), 10001, FormatterMessages.JavaPreview_formatter_exception, (Throwable)e);
                JavaPlugin.log((IStatus)status);
                continue;
            }
            buffer.append("\n");
            buffer.append(formattedSource);
            buffer.append("\n");
            buffer.append("\n");
        }
        this.fPreviewDocument.set(buffer.toString());
    }

    public void add(PreviewSnippet snippet) {
        this.fSnippets.add(snippet);
    }

    public void remove(PreviewSnippet snippet) {
        this.fSnippets.remove(snippet);
    }

    public void addAll(Collection<PreviewSnippet> snippets) {
        this.fSnippets.addAll(snippets);
    }

    public void clear() {
        this.fSnippets.clear();
    }

    public static final class PreviewSnippet {
        public String header;
        public final String source;
        public final int kind;

        public PreviewSnippet(int kind, String source) {
            this.kind = kind;
            this.source = source;
        }
    }
}

