/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.jface.internal.databinding.swt.WidgetListenerUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class WidgetListener
extends NativePropertyListener
implements Listener {
    private final int[] changeEvents;
    private final int[] staleEvents;

    public WidgetListener(IProperty property, ISimplePropertyListener listener, int[] changeEvents, int[] staleEvents) {
        super(property, listener);
        this.changeEvents = changeEvents;
        this.staleEvents = staleEvents;
    }

    public void handleEvent(Event event) {
        int n;
        int n2;
        int[] nArray;
        if (this.staleEvents != null) {
            nArray = this.staleEvents;
            n2 = this.staleEvents.length;
            n = 0;
            while (n < n2) {
                int staleEvent = nArray[n];
                if (event.type == staleEvent) {
                    this.fireStale(event.widget);
                    break;
                }
                ++n;
            }
        }
        if (this.changeEvents != null) {
            nArray = this.changeEvents;
            n2 = this.changeEvents.length;
            n = 0;
            while (n < n2) {
                int changeEvent = nArray[n];
                if (event.type == changeEvent) {
                    this.fireChange(event.widget, null);
                    break;
                }
                ++n;
            }
        }
    }

    protected void doAddTo(Object source) {
        int event;
        int n;
        int n2;
        int[] nArray;
        Widget widget = (Widget)source;
        if (this.changeEvents != null) {
            nArray = this.changeEvents;
            n2 = this.changeEvents.length;
            n = 0;
            while (n < n2) {
                event = nArray[n];
                if (event != 0) {
                    WidgetListenerUtil.asyncAddListener(widget, event, this);
                }
                ++n;
            }
        }
        if (this.staleEvents != null) {
            nArray = this.staleEvents;
            n2 = this.staleEvents.length;
            n = 0;
            while (n < n2) {
                event = nArray[n];
                if (event != 0) {
                    WidgetListenerUtil.asyncAddListener(widget, event, this);
                }
                ++n;
            }
        }
    }

    protected void doRemoveFrom(Object source) {
        Widget widget = (Widget)source;
        if (!widget.isDisposed()) {
            int event;
            int n;
            int n2;
            int[] nArray;
            if (this.changeEvents != null) {
                nArray = this.changeEvents;
                n2 = this.changeEvents.length;
                n = 0;
                while (n < n2) {
                    event = nArray[n];
                    if (event != 0) {
                        WidgetListenerUtil.asyncRemoveListener(widget, event, this);
                    }
                    ++n;
                }
            }
            if (this.staleEvents != null) {
                nArray = this.staleEvents;
                n2 = this.staleEvents.length;
                n = 0;
                while (n < n2) {
                    event = nArray[n];
                    if (event != 0) {
                        WidgetListenerUtil.asyncRemoveListener(widget, event, this);
                    }
                    ++n;
                }
            }
        }
    }
}

