/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenTypeHierarchyAction_label);
        this.setToolTipText(ActionMessages.OpenTypeHierarchyAction_tooltip);
        this.setDescription(ActionMessages.OpenTypeHierarchyAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_type_hierarchy_action");
    }

    @Deprecated
    public OpenTypeHierarchyAction(IWorkbenchSite site, ISelectionProvider provider) {
        this(site);
        this.setSpecialSelectionProvider(provider);
    }

    public OpenTypeHierarchyAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        Object[] elements = selection.toArray();
        if (elements.length == 0) {
            return false;
        }
        if (elements.length == 1) {
            Object input = elements[0];
            if (input instanceof LogicalPackage) {
                return true;
            }
            if (!(input instanceof IJavaElement)) {
                return false;
            }
            switch (((IJavaElement)input).getElementType()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    return true;
                }
                case 14: 
                case 15: 
                case 16: {
                    return false;
                }
            }
        }
        boolean hasValidElement = false;
        int j = 0;
        while (j < elements.length) {
            Object input = elements[j];
            if (input instanceof LogicalPackage) {
                hasValidElement = true;
            } else if (input instanceof IJavaElement) {
                switch (((IJavaElement)input).getElementType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 11: {
                        hasValidElement = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ++j;
        }
        return hasValidElement;
    }

    @Override
    public void run(ITextSelection selection) {
        ITypeRoot input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaElement)input)) {
            return;
        }
        try {
            IJavaElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList<IJavaElement> candidates = new ArrayList<IJavaElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IJavaElement[] resolvedElements = OpenTypeHierarchyUtil.getCandidates(elements[i]);
                if (resolvedElements != null) {
                    candidates.addAll(Arrays.asList(resolvedElements));
                }
                ++i;
            }
            this.run(candidates.toArray(new IJavaElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), OpenTypeHierarchyAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void run(IStructuredSelection selection) {
        ArrayList<IJavaElement> validElements = new ArrayList<IJavaElement>();
        Object[] selectedElements = selection.toArray();
        int i = 0;
        while (i < selectedElements.length) {
            block15: {
                Object input = selectedElements[i];
                if (input instanceof LogicalPackage) {
                    IPackageFragment[] fragments = ((LogicalPackage)((Object)input)).getFragments();
                    if (fragments.length != 0) {
                        int j = 0;
                        while (j < fragments.length) {
                            validElements.add((IJavaElement)fragments[j]);
                            ++j;
                        }
                    }
                } else if (input instanceof IPackageFragment) {
                    IPackageFragmentRoot[] roots;
                    IPackageFragment fragment = (IPackageFragment)input;
                    try {
                        roots = fragment.getJavaProject().getPackageFragmentRoots();
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                        break block15;
                    }
                    String name = fragment.getElementName();
                    int j = 0;
                    while (j < roots.length) {
                        IPackageFragment pack = roots[j].getPackageFragment(name);
                        if (pack.exists()) {
                            validElements.add((IJavaElement)pack);
                        }
                        ++j;
                    }
                } else if (input instanceof IJavaElement && ActionUtil.isProcessable(this.getShell(), (IJavaElement)input)) {
                    IJavaElement element = (IJavaElement)input;
                    validElements.add(element);
                }
            }
            ++i;
        }
        if (validElements.size() == 0) {
            IStatus status = OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_java_elements);
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)status);
            return;
        }
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        IStatus status = OpenTypeHierarchyAction.compileCandidates(result, validElements);
        if (status.isOK()) {
            this.run(result.toArray(new IJavaElement[result.size()]));
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)status);
        }
    }

    public void run(IJavaElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyUtil.open(elements, this.getSite().getWorkbenchWindow());
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenTypeHierarchyAction_dialog_title;
    }

    private static IStatus compileCandidates(List<IJavaElement> result, List<IJavaElement> elements) {
        IStatus ok = Status.OK_STATUS;
        boolean onlyContainers = true;
        block11: for (Object elem : elements) {
            try {
                switch (elem.getElementType()) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        onlyContainers = false;
                    }
                    case 2: 
                    case 3: {
                        result.add((IJavaElement)elem);
                        break;
                    }
                    case 4: {
                        if (!((IPackageFragment)elem).containsJavaResources()) continue block11;
                        result.add((IJavaElement)elem);
                        break;
                    }
                    case 11: {
                        result.add(elem.getAncestor(4));
                        break;
                    }
                    case 13: {
                        IImportDeclaration decl = (IImportDeclaration)elem;
                        elem = decl.isOnDemand() ? JavaModelUtil.findTypeContainer((IJavaProject)elem.getJavaProject(), (String)Signature.getQualifier((String)elem.getElementName())) : elem.getJavaProject().findType(elem.getElementName());
                        if (elem == null) continue block11;
                        onlyContainers = false;
                        result.add((IJavaElement)elem);
                        break;
                    }
                    case 6: {
                        if (!(elem instanceof IOrdinaryClassFile)) continue block11;
                        onlyContainers = false;
                        result.add((IJavaElement)((IOrdinaryClassFile)elem).getType());
                        break;
                    }
                    case 5: {
                        ICompilationUnit cu = (ICompilationUnit)elem;
                        IType[] types = cu.getTypes();
                        if (types.length <= 0) continue block11;
                        onlyContainers = false;
                        result.addAll(Arrays.asList(types));
                    }
                }
            }
            catch (JavaModelException e) {
                return e.getStatus();
            }
        }
        int size = result.size();
        if (size == 0 || size > 1 && !onlyContainers) {
            return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_valid_java_element);
        }
        return ok;
    }

    private static IStatus createStatus(String message) {
        return new Status(1, JavaPlugin.getPluginId(), 10001, message, null);
    }
}

