/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractTemplateCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;

public class TemplateCompletionProposalComputer
extends AbstractTemplateCompletionProposalComputer {
    private final TemplateEngine fJavaTemplateEngine;
    private final TemplateEngine fJavaStatementsTemplateEngine;
    private final TemplateEngine fJavaMembersTemplateEngine;
    private final TemplateEngine fJavadocTemplateEngine;

    public TemplateCompletionProposalComputer() {
        ContextTypeRegistry templateContextRegistry = JavaPlugin.getDefault().getTemplateContextRegistry();
        this.fJavaTemplateEngine = TemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "java");
        this.fJavaMembersTemplateEngine = TemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "java-members");
        this.fJavaStatementsTemplateEngine = TemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "java-statements");
        this.fJavadocTemplateEngine = TemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "javadoc");
    }

    private static TemplateEngine createTemplateEngine(ContextTypeRegistry templateContextRegistry, String contextTypeId) {
        TemplateContextType contextType = templateContextRegistry.getContextType(contextTypeId);
        Assert.isNotNull((Object)contextType);
        return new TemplateEngine(contextType);
    }

    @Override
    protected TemplateEngine computeCompletionEngine(JavaContentAssistInvocationContext context) {
        try {
            String partition = TextUtilities.getContentType((IDocument)context.getDocument(), (String)"___java_partitioning", (int)context.getInvocationOffset(), (boolean)true);
            if (partition.equals("__java_javadoc")) {
                return this.fJavadocTemplateEngine;
            }
            CompletionContext coreContext = context.getCoreContext();
            if (coreContext != null) {
                int tokenLocation = coreContext.getTokenLocation();
                if ((tokenLocation & 1) != 0) {
                    return this.fJavaMembersTemplateEngine;
                }
                if ((tokenLocation & 2) != 0) {
                    return this.fJavaStatementsTemplateEngine;
                }
            }
            return this.fJavaTemplateEngine;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

