/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.swt.widgets.Control;

public class FilterUpdater
implements IResourceChangeListener {
    private ProblemTreeViewer fViewer;

    public FilterUpdater(ProblemTreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fViewer.getInput() == null) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
        int i = 0;
        while (i < projDeltas.length) {
            IProject project;
            IResourceDelta pDelta = projDeltas[i];
            if ((pDelta.getFlags() & 0x80000) != 0 && this.needsRefiltering(project = (IProject)pDelta.getResource())) {
                final Control ctrl = this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ctrl.isDisposed()) {
                                FilterUpdater.this.fViewer.refresh(false);
                            }
                        }
                    });
                }
                return;
            }
            ++i;
        }
    }

    private boolean needsRefiltering(IProject project) {
        try {
            IProject element = project;
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                element = JavaCore.create((IProject)project);
            }
            boolean inView = this.fViewer.testFindItem(element) != null;
            boolean afterFilter = !this.fViewer.isFiltered(element, this.fViewer.getInput());
            return inView ^ afterFilter;
        }
        catch (CoreException coreException) {
            return true;
        }
    }
}

