/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.CommitUtil;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;

public class SquashHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        List<RevCommit> commits = this.getSelectedCommits(event);
        try {
            if (!CommitUtil.areCommitsInCurrentBranch(commits, (Repository)repository)) {
                MessageDialog.openError((Shell)this.getPart(event).getSite().getShell(), (String)UIText.SquashHandler_Error_Title, (String)UIText.SquashHandler_CommitsNotOnCurrentBranch);
                return null;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.SquashHandler_ErrorCheckingIfCommitsAreOnCurrentBranch, (Throwable)e);
        }
        ArrayList<RepositoryCommit> repositoryCommits = new ArrayList<RepositoryCommit>();
        for (RevCommit commit : commits) {
            repositoryCommits.add(new RepositoryCommit(repository, commit));
        }
        StructuredSelection selected = new StructuredSelection(repositoryCommits);
        CommonUtils.runCommand("org.eclipse.egit.ui.commit.Squash", (IStructuredSelection)selected);
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection selection = this.getSelection(page);
        if (selection.isEmpty()) {
            return false;
        }
        Repository repository = this.getRepository(page);
        if (repository.getRepositoryState() != RepositoryState.SAFE) {
            return false;
        }
        List elements = selection.toList();
        int parentsNotSelected = 0;
        for (Object element : elements) {
            RevCommit commit = (RevCommit)element;
            if (commit.getParentCount() != 1) {
                return false;
            }
            RevCommit parentCommit = commit.getParent(0);
            if (!elements.contains(parentCommit)) {
                ++parentsNotSelected;
            }
            if (parentsNotSelected <= 1) continue;
            return false;
        }
        return parentsNotSelected == true;
    }
}

