/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.gmf.runtime.diagram.ui.actions.CheckedPropertyAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions.ModesMenuManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.EditorActionBarContributor;

public class LayoutingModeSwitchingAction
extends CheckedPropertyAction {
    private static final ImageDescriptor ACTIVATE_LAYOUTING_MODE_IMAGE_DESCRIPTOR = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/layoutingMode_activate.png");
    private DDiagram ddiagram;
    private DDiagramEditor editor;
    private ModesMenuManager modesMenuManager;

    public LayoutingModeSwitchingAction(IWorkbenchPage page, DDiagramEditor editor, DDiagram editorDiagram, ModesMenuManager modesMenuManager) {
        super(page, "switchLayoutingMode", Messages.ChangeEditModeAction_ChangePropertyValueRequest_label, (Object)"switchLayoutingMode");
        this.setWorkbenchPart(page.getActivePart());
        this.setId("switchLayoutingMode");
        this.ddiagram = editorDiagram;
        this.setImageDescriptor(ACTIVATE_LAYOUTING_MODE_IMAGE_DESCRIPTOR);
        this.setTextAndStatusAccordingToLayoutingMode();
        this.setToolTipText(Messages.EditModeAction_Label);
        this.editor = editor;
        this.modesMenuManager = modesMenuManager;
    }

    protected boolean calculateChecked() {
        return this.ddiagram != null && this.ddiagram.isIsInLayoutingMode();
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)this.editor.getEditingDomain();
        if (editingDomain != null) {
            TransactionImpl t = new TransactionImpl(editingDomain, false, Collections.EMPTY_MAP);
            try {
                t.start();
                this.ddiagram.setIsInLayoutingMode(true);
                this.ddiagram.setIsInShowingMode(false);
                t.commit();
            }
            catch (InterruptedException | RollbackException e) {
                DiagramPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram", Messages.ChangeEditModeAction_ChangeFailure, e));
            }
        }
        this.modesMenuManager.refresh();
        this.setTextAndStatusAccordingToLayoutingMode();
    }

    protected boolean calculateEnabled() {
        return this.ddiagram != null && this.editor != null;
    }

    private void setTextAndStatusAccordingToLayoutingMode() {
        this.setText(Messages.LayoutingModeSwitchingAction_label);
        IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
        if (activeEditor != null) {
            IEditorSite site = (IEditorSite)activeEditor.getSite();
            EditorActionBarContributor actionBarContributor = null;
            IStatusLineManager statusLineManager = null;
            if (site != null && site.getActionBarContributor() instanceof EditorActionBarContributor) {
                actionBarContributor = (EditorActionBarContributor)site.getActionBarContributor();
            }
            if (actionBarContributor != null && actionBarContributor.getActionBars() != null) {
                statusLineManager = actionBarContributor.getActionBars().getStatusLineManager();
            }
            if (statusLineManager != null) {
                if (this.ddiagram != null && this.ddiagram.isIsInLayoutingMode()) {
                    String statusMessage = Messages.LayoutingModeSwitchingAction_statusOn;
                    statusLineManager.setMessage(DiagramUIPlugin.getPlugin().getImage(ACTIVATE_LAYOUTING_MODE_IMAGE_DESCRIPTOR), statusMessage);
                } else {
                    statusLineManager.setMessage("");
                }
            }
        }
    }

    public int getStyle() {
        return 2;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    public void dispose() {
        this.ddiagram = null;
        this.modesMenuManager = null;
        this.editor = null;
        super.dispose();
    }

    public static boolean diagramAllowsLayoutingMode(DDiagram diagram) {
        if (diagram == null || diagram.getDescription() == null) {
            return false;
        }
        boolean diagramAllowsLayoutingMode = true;
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(diagram.getDescription().eClass().getEPackage())) continue;
            diagramAllowsLayoutingMode = diagramAllowsLayoutingMode && diagramTypeDescriptor.getDiagramDescriptionProvider().allowsLayoutingModeActivation();
            break;
        }
        return diagramAllowsLayoutingMode;
    }
}

