/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.cst;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CollectionTypeIdentifierEnum implements Enumerator
{
    SET_LITERAL(1, "Set", "Set"),
    BAG_LITERAL(2, "Bag", "Bag"),
    SEQUENCE_LITERAL(3, "Sequence", "Sequence"),
    COLLECTION_LITERAL(4, "Collection", "Collection"),
    ORDERED_SET_LITERAL(5, "OrderedSet", "OrderedSet");

    public static final int SET = 1;
    public static final int BAG = 2;
    public static final int SEQUENCE = 3;
    public static final int COLLECTION = 4;
    public static final int ORDERED_SET = 5;
    private static final CollectionTypeIdentifierEnum[] VALUES_ARRAY;
    public static final List<CollectionTypeIdentifierEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CollectionTypeIdentifierEnum[]{SET_LITERAL, BAG_LITERAL, SEQUENCE_LITERAL, COLLECTION_LITERAL, ORDERED_SET_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CollectionTypeIdentifierEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionTypeIdentifierEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionTypeIdentifierEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionTypeIdentifierEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionTypeIdentifierEnum get(int value) {
        switch (value) {
            case 1: {
                return SET_LITERAL;
            }
            case 2: {
                return BAG_LITERAL;
            }
            case 3: {
                return SEQUENCE_LITERAL;
            }
            case 4: {
                return COLLECTION_LITERAL;
            }
            case 5: {
                return ORDERED_SET_LITERAL;
            }
        }
        return null;
    }

    private CollectionTypeIdentifierEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

