/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.resource.WorkspaceDragAndDropSupport;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.DnDTasksOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.api.ui.resource.ISiriusMessages;
import org.eclipse.sirius.tools.internal.command.builders.ElementsToSelectTask;
import org.eclipse.sirius.viewpoint.DFile;
import org.eclipse.sirius.viewpoint.DModel;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class DragAndDropCommandBuilder
extends AbstractDiagramCommandBuilder {
    private ContainerDropDescription tool;
    private DragAndDropTarget container;
    private DDiagramElement diagramElement;
    private EObject droppedElement;
    private boolean dragSemantic;

    public DragAndDropCommandBuilder(ContainerDropDescription tool, DragAndDropTarget container, DDiagramElement diagramElement) {
        this.tool = tool;
        this.container = container;
        this.diagramElement = diagramElement;
        this.dragSemantic = false;
    }

    public DragAndDropCommandBuilder(ContainerDropDescription tool, DragAndDropTarget container, EObject droppedElement) {
        this.tool = tool;
        this.container = container;
        this.droppedElement = droppedElement;
        this.dragSemantic = true;
    }

    private DSemanticDecorator getOldContainer() {
        EObject semanticOldContainer = null;
        DSemanticDecorator oldContainer = null;
        EObject currentOldContainer = this.diagramElement.eContainer();
        while (currentOldContainer != null && semanticOldContainer == null) {
            if (currentOldContainer instanceof DSemanticDecorator) {
                oldContainer = (DSemanticDecorator)currentOldContainer;
                semanticOldContainer = oldContainer.getTarget();
            }
            currentOldContainer = currentOldContainer.eContainer();
        }
        return oldContainer;
    }

    public Command buildCommand() {
        if (this.permissionAuthority.canEditInstance((EObject)this.container) && this.permissionAuthority.canEditInstance((EObject)(this.dragSemantic ? this.droppedElement : this.diagramElement)) && !this.isInLayoutingModeDiagram((EObject)this.diagramElement) && !this.isInShowingModeDiagram(this.diagramElement)) {
            if (this.container instanceof DSemanticDecorator) {
                DiagramElementMapping mapping;
                EObject semanticOldContainer;
                EObject semanticContainer = ((DSemanticDecorator)this.container).getTarget();
                if (!this.dragSemantic) {
                    this.droppedElement = this.diagramElement.getTarget();
                }
                DSemanticDecorator oldContainer = this.dragSemantic ? null : this.getOldContainer();
                EObject eObject = semanticOldContainer = this.dragSemantic ? null : oldContainer.getTarget();
                if (this.checkDragAndDropPrecondition(semanticOldContainer, semanticContainer) && ((mapping = ContainerMappingWithInterpreterHelper.getBestMapping(this.tool, this.container, this.droppedElement)) != null || this.dragSemantic)) {
                    DCommand cmd = this.buildDropInContainerCommandFromTool(semanticContainer, this.droppedElement, (EObject)this.container, semanticOldContainer);
                    this.fillDropinCommand(cmd, mapping, semanticContainer);
                    this.cleanAfterDropinCommand(cmd, oldContainer);
                    DDiagram diagram = (DDiagram)this.getDDiagram().get();
                    this.addRefreshTask(diagram, cmd, (AbstractToolDescription)this.tool);
                    cmd.getTasks().add(new ElementsToSelectTask((AbstractToolDescription)this.tool, InterpreterUtil.getInterpreter((EObject)semanticContainer), semanticContainer, (DRepresentation)diagram));
                    return cmd;
                }
            } else {
                SiriusPlugin.getDefault().error(ISiriusMessages.IS_NOT_A_DECORATE_SEMANTIC_ELEMENT, (Throwable)new RuntimeException());
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private boolean checkDragAndDropPrecondition(EObject oldContainer, EObject newContainer) {
        return DnDTasksOperations.checkDragAndDropPrecondition(this.tool, this.droppedElement, oldContainer, newContainer, (EObject)this.container);
    }

    private void fillDropinCommand(DCommand cmd, DiagramElementMapping mapping, EObject semanticContainer) {
        AbstractCommandTask createElement = null;
        boolean moveEdges = this.tool.isMoveEdges();
        if (mapping instanceof NodeMapping) {
            createElement = DnDTasksOperations.createDropinForNodeTask(this.container, (NodeMapping)mapping, this.diagramElement, this.droppedElement, semanticContainer, moveEdges);
        } else if (!(mapping instanceof EdgeMapping) && mapping instanceof ContainerMapping) {
            createElement = DnDTasksOperations.createDropinForContainerTask(this.container, (ContainerMapping)mapping, this.diagramElement, this.droppedElement, semanticContainer, this.tool);
        }
        if (createElement != null) {
            cmd.getTasks().add(createElement);
        }
    }

    private void cleanAfterDropinCommand(DCommand cmd, DSemanticDecorator oldContainer) {
        if (!this.dragSemantic) {
            cmd.getTasks().add(DnDTasksOperations.createRemoveAfterDropInTask((EObject)oldContainer, (EObject)this.diagramElement));
        }
    }

    private DCommand buildDropInContainerCommandFromTool(final EObject newContainer, final EObject element, EObject dContainer, EObject oldContainer) {
        DCommand result = this.createEnclosingCommand();
        if (this.permissionAuthority.canEditInstance(newContainer) && this.permissionAuthority.canEditInstance(element)) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)newContainer);
            final HashMap<Object, EObject> variables = new HashMap<Object, EObject>();
            variables.put(this.tool.getElement(), element);
            variables.put(this.tool.getNewContainer(), newContainer);
            variables.put(this.tool.getNewViewContainer(), dContainer);
            if (oldContainer != null) {
                variables.put(this.tool.getOldContainer(), oldContainer);
            }
            result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback){

                public void execute() {
                    if (element instanceof DModel) {
                        this.setElementVariableWithModelContent((DModel)element);
                    }
                    super.execute();
                }

                private void setElementVariableWithModelContent(DModel model) {
                    WorkspaceDragAndDropSupport support = new WorkspaceDragAndDropSupport();
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)newContainer);
                    IFile file = support.getWorkspaceFile((DFile)model);
                    Resource loadedResource = DragAndDropCommandBuilder.this.uiCallback.loadResource((EditingDomain)domain, file);
                    if (loadedResource != null) {
                        EObject newElement;
                        Session session = SessionManager.INSTANCE.getSession((EObject)model);
                        support.addSemanticResourceToSession(loadedResource, session);
                        if (!loadedResource.getContents().isEmpty() && (newElement = (EObject)loadedResource.getContents().get(0)) != null) {
                            variables.put(DragAndDropCommandBuilder.this.tool.getElement(), newElement);
                        }
                    }
                }
            });
            Option representation = new EObjectQuery((EObject)this.diagramElement).getRepresentation();
            if (this.tool.getInitialOperation() != null && this.tool.getInitialOperation().getFirstModelOperations() != null) {
                result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)representation.get(), newContainer, this.tool.getInitialOperation().getFirstModelOperations()));
            }
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    protected String getEnclosingCommandLabel() {
        return new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel();
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        DDiagram diag = null;
        diag = this.container instanceof DDiagram ? (DDiagram)this.container : ((DDiagramElement)((Object)this.container)).getParentDiagram();
        return Options.newSome((Object)diag);
    }
}

