/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.DirectoryProposalContentAssist;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ChooseWorkspaceDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "ChooseWorkspaceDialogSettings";
    private ChooseWorkspaceData launchData;
    private Combo text;
    private boolean suppressAskAgain = false;
    private boolean centerOnMonitor = false;
    private Map<String, Link> recentWorkspacesLinks;
    private Form recentWorkspacesForm;
    private Button defaultButton;

    public ChooseWorkspaceDialog(Shell parentShell, ChooseWorkspaceData launchData, boolean suppressAskAgain, boolean centerOnMonitor) {
        super(parentShell);
        this.launchData = launchData;
        this.suppressAskAgain = suppressAskAgain;
        this.centerOnMonitor = centerOnMonitor;
    }

    public void prompt(boolean force) {
        if (force || this.launchData.getShowDialog()) {
            this.open();
            if (this.getReturnCode() == 1) {
                this.launchData.workspaceSelected(null);
            }
            return;
        }
        String[] recent = this.launchData.getRecentWorkspaces();
        String workspace = null;
        if (recent != null && recent.length > 0) {
            workspace = recent[0];
        }
        if (workspace == null || workspace.isEmpty()) {
            workspace = this.launchData.getInitialDefault();
        }
        this.launchData.workspaceSelected(TextProcessor.deprocess((String)workspace));
    }

    protected Control createDialogArea(Composite parent) {
        String productName = ChooseWorkspaceDialog.getWindowTitle();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogTitle);
        this.setMessage(NLS.bind((String)IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogMessage, (Object)productName));
        if (this.getTitleImageLabel() != null) {
            this.getTitleImageLabel().setVisible(false);
        }
        boolean createRecentWorkspacesComposite = false;
        if (this.launchData.getRecentWorkspaces()[0] != null) {
            createRecentWorkspacesComposite = true;
        }
        this.createWorkspaceBrowseRow(composite);
        if (!this.suppressAskAgain) {
            this.createShowDialogButton(composite);
        }
        if (createRecentWorkspacesComposite) {
            this.createRecentWorkspacesComposite(composite);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDEWorkbenchMessages.ChooseWorkspaceDialog_launchLabel, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public static String getWindowTitle() {
        String productName = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            productName = product.getName();
        }
        if (productName == null) {
            productName = IDEWorkbenchMessages.ChooseWorkspaceDialog_defaultProductName;
        }
        return productName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogName, (Object)ChooseWorkspaceDialog.getWindowTitle()));
        shell.addTraverseListener(e -> {
            if (e.detail == 2) {
                e.detail = 0;
                this.cancelPressed();
            }
        });
    }

    protected void okPressed() {
        this.workspaceSelected(this.getWorkspaceLocation());
    }

    private void workspaceSelected(String workspace) {
        this.launchData.workspaceSelected(TextProcessor.deprocess((String)workspace));
        super.okPressed();
    }

    private void removeWorkspaceFromLauncher(String workspace) {
        ArrayList<String> recentWorkpaces = new ArrayList<String>(Arrays.asList(this.launchData.getRecentWorkspaces()));
        recentWorkpaces.remove(workspace);
        this.launchData.setRecentWorkspaces(recentWorkpaces.toArray(new String[0]));
        this.launchData.writePersistedData();
        this.recentWorkspacesLinks.get(workspace).dispose();
        this.recentWorkspacesLinks.remove(workspace);
        if (this.recentWorkspacesLinks.isEmpty()) {
            this.recentWorkspacesForm.dispose();
        }
        this.getShell().layout();
        this.initializeBounds();
        this.text.remove(workspace);
        if (this.text.getText().equals(workspace) || this.text.getText().isEmpty()) {
            this.text.setText(TextProcessor.process((String)(this.text.getItemCount() > 0 ? this.text.getItem(0) : this.launchData.getInitialDefault())));
        }
    }

    protected String getWorkspaceLocation() {
        return this.text.getText();
    }

    protected void cancelPressed() {
        this.launchData.workspaceSelected(null);
        super.cancelPressed();
    }

    private void createRecentWorkspacesComposite(Composite composite) {
        FormToolkit toolkit = new FormToolkit(composite.getDisplay());
        composite.addDisposeListener(c -> toolkit.dispose());
        this.recentWorkspacesForm = toolkit.createForm(composite);
        this.recentWorkspacesForm.setBackground(composite.getBackground());
        this.recentWorkspacesForm.getBody().setLayout((Layout)new GridLayout());
        ExpandableComposite recentWorkspacesExpandable = toolkit.createExpandableComposite(this.recentWorkspacesForm.getBody(), 2);
        this.recentWorkspacesForm.setLayoutData((Object)new GridData(4, 4, true, false));
        recentWorkspacesExpandable.setBackground(composite.getBackground());
        recentWorkspacesExpandable.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_recentWorkspaces);
        recentWorkspacesExpandable.setExpanded(this.launchData.isShowRecentWorkspaces());
        recentWorkspacesExpandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ChooseWorkspaceDialog.this.launchData.setShowRecentWorkspaces(((ExpandableComposite)e.getSource()).isExpanded());
                Point size = ChooseWorkspaceDialog.this.getInitialSize();
                Shell shell = ChooseWorkspaceDialog.this.getShell();
                shell.setBounds(ChooseWorkspaceDialog.this.getConstrainedShellBounds(new Rectangle(shell.getLocation().x, shell.getLocation().y, size.x, size.y)));
            }
        });
        Composite panel = new Composite((Composite)recentWorkspacesExpandable, 0);
        recentWorkspacesExpandable.setClient((Control)panel);
        RowLayout layout = new RowLayout(512);
        layout.marginLeft = 14;
        layout.spacing = 6;
        panel.setLayout((Layout)layout);
        this.recentWorkspacesLinks = new HashMap<String, Link>(this.launchData.getRecentWorkspaces().length);
        Map<String, String> uniqueWorkspaceNames = this.createUniqueWorkspaceNameMap();
        List recentWorkspacesList = Arrays.asList(this.launchData.getRecentWorkspaces()).stream().filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList());
        List sortedList = uniqueWorkspaceNames.entrySet().stream().sorted((e1, e2) -> Integer.compare(recentWorkspacesList.indexOf(e1.getValue()), recentWorkspacesList.indexOf(e2.getValue()))).collect(Collectors.toList());
        for (Map.Entry uniqueWorkspaceEntry : sortedList) {
            final String recentWorkspace = (String)uniqueWorkspaceEntry.getValue();
            Link link = new Link(panel, 64);
            link.setLayoutData((Object)new RowData(-1, -1));
            link.setText("<a>" + (String)uniqueWorkspaceEntry.getKey() + "</a>");
            link.setToolTipText(recentWorkspace);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseWorkspaceDialog.this.workspaceSelected(recentWorkspace);
                }
            });
            this.recentWorkspacesLinks.put(recentWorkspace, link);
            Menu menu = new Menu((Control)link);
            MenuItem forgetItem = new MenuItem(menu, 8);
            forgetItem.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_removeWorkspaceSelection);
            forgetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseWorkspaceDialog.this.removeWorkspaceFromLauncher(recentWorkspace);
                }
            });
            link.setMenu(menu);
        }
    }

    private Map<String, String> createUniqueWorkspaceNameMap() {
        String fileSeparator = File.separator;
        HashMap<String, String> uniqueWorkspaceNameMap = new HashMap<String, String>();
        List splittedWorkspaceNames = Arrays.asList(this.launchData.getRecentWorkspaces()).stream().filter(s -> s != null && !s.isEmpty()).map(s -> s.split(Pattern.quote(fileSeparator))).collect(Collectors.toList());
        int i = 1;
        while (!splittedWorkspaceNames.isEmpty()) {
            int c = i++;
            Function<String[], String> stringArraytoName = s -> String.join((CharSequence)fileSeparator, ((String[])s).length < c ? s : (CharSequence[])Arrays.copyOfRange(s, ((String[])s).length - c, ((String[])s).length));
            List uniqueNames = splittedWorkspaceNames.stream().map(stringArraytoName).collect(Collectors.groupingBy(s -> s, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() == 1L).map(Map.Entry::getKey).collect(Collectors.toList());
            splittedWorkspaceNames.removeIf(a -> {
                String joined = (String)stringArraytoName.apply((String[])a);
                if (uniqueNames.contains(joined)) {
                    uniqueWorkspaceNameMap.put(joined, String.join((CharSequence)fileSeparator, a));
                    return true;
                }
                return false;
            });
        }
        return uniqueWorkspaceNameMap;
    }

    private void createWorkspaceBrowseRow(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        panel.setFont(parent.getFont());
        CLabel label = new CLabel(panel, 0);
        label.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_workspaceEntryLabel);
        label.setMargins(0, 0, 2, 0);
        this.text = new Combo(panel, 18436);
        new DirectoryProposalContentAssist().apply(this.text);
        this.text.setTextDirection(0x6000000);
        this.text.setFocus();
        this.text.setLayoutData((Object)new GridData(400, -1));
        this.text.addModifyListener(e -> {
            Button okButton = this.getButton(0);
            if (okButton != null && !okButton.isDisposed()) {
                boolean nonWhitespaceFound = false;
                String characters = this.getWorkspaceLocation();
                int i = 0;
                while (!nonWhitespaceFound && i < characters.length()) {
                    if (!Character.isWhitespace(characters.charAt(i))) {
                        nonWhitespaceFound = true;
                    }
                    ++i;
                }
                okButton.setEnabled(nonWhitespaceFound);
            }
        });
        this.setInitialTextValues(this.text);
        Button browseButton = new Button(panel, 8);
        browseButton.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_browseLabel);
        this.setButtonLayoutData(browseButton);
        GridData data = (GridData)browseButton.getLayoutData();
        data.horizontalAlignment = 128;
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ChooseWorkspaceDialog.this.getShell(), 0x10000000);
                dialog.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_directoryBrowserTitle);
                dialog.setMessage(IDEWorkbenchMessages.ChooseWorkspaceDialog_directoryBrowserMessage);
                dialog.setFilterPath(ChooseWorkspaceDialog.this.getInitialBrowsePath());
                String dir = dialog.open();
                if (dir != null) {
                    ChooseWorkspaceDialog.this.text.setText(TextProcessor.process((String)dir));
                }
            }
        });
    }

    protected String getInitialBrowsePath() {
        File dir = new File(this.getWorkspaceLocation());
        while (dir != null && !dir.exists()) {
            dir = dir.getParentFile();
        }
        return dir != null ? dir.getAbsolutePath() : System.getProperty("user.dir");
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        if (!this.centerOnMonitor || parent == null) {
            return super.getInitialLocation(initialSize);
        }
        Monitor monitor = parent.getMonitor();
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    private void createShowDialogButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        panel.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalAlignment = 3;
        panel.setLayoutData((Object)data);
        this.defaultButton = new Button(panel, 32);
        this.defaultButton.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_useDefaultMessage);
        this.defaultButton.setSelection(!this.launchData.getShowDialog());
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseWorkspaceDialog.this.launchData.toggleShowDialog();
            }
        });
    }

    private void setInitialTextValues(Combo text) {
        String[] stringArray = this.launchData.getRecentWorkspaces();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String recentWorkspace = stringArray[n2];
            if (recentWorkspace != null) {
                text.add(recentWorkspace);
            }
            ++n2;
        }
        text.setText(TextProcessor.process((String)(text.getItemCount() > 0 ? text.getItem(0) : this.launchData.getInitialDefault())));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        if (this.centerOnMonitor) {
            return null;
        }
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    public Combo getCombo() {
        return this.text;
    }

    public Form getRecentWorkspacesForm() {
        return this.recentWorkspacesForm;
    }

    public Button getDefaultButton() {
        return this.defaultButton;
    }
}

