/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.action;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.dialect.command.RenameRepresentationCommand;
import org.eclipse.sirius.common.ui.tools.api.dialog.RenameDialog;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;

public class RenameRepresentationAction
extends Action {
    private Collection<DRepresentationDescriptor> selectedRepDescriptors;

    public RenameRepresentationAction(Collection<DRepresentationDescriptor> selectedRepDescriptors) {
        super(Messages.RenameRepresentationAction_name);
        this.selectedRepDescriptors = selectedRepDescriptors;
    }

    public void run() {
        for (DRepresentationDescriptor repDesc : this.selectedRepDescriptors) {
            this.renameRepresentation(repDesc);
        }
    }

    private void renameRepresentation(DRepresentationDescriptor repDescriptor) {
        String newName;
        String oldName = repDescriptor.getName() != null ? repDescriptor.getName() : "";
        RenameDialog dialog = new RenameDialog(Display.getCurrent().getActiveShell(), true, oldName);
        dialog.create();
        if (dialog.open() == 0 && !oldName.equals(newName = dialog.getNewName())) {
            TransactionalEditingDomain transDomain = TransactionUtil.getEditingDomain((EObject)repDescriptor);
            transDomain.getCommandStack().execute((Command)new RenameRepresentationCommand(transDomain, repDescriptor, newName));
        }
    }

    public boolean isEnabled() {
        boolean isEnabled = super.isEnabled();
        if (isEnabled) {
            for (DRepresentationDescriptor dRepDescriptor : this.selectedRepDescriptors) {
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)dRepDescriptor);
                if (permissionAuthority.canEditFeature((EObject)dRepDescriptor, ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Name().getName())) continue;
                isEnabled = false;
                break;
            }
        }
        return isEnabled;
    }
}

