/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserManager;

public class CurrentBrowser
implements IBrowser {
    private IBrowser browserAdapter;
    private String browserAdapterId;
    private IBrowser newBrowserAdapter = null;
    private String newBrowserAdapterId = null;
    private boolean locationSet = false;
    private boolean sizeSet = false;
    private int x;
    private int y;
    private int width;
    private int height;
    boolean external;

    public CurrentBrowser(IBrowser browserImpl, String browserAdapterId, boolean externalBrowser) {
        this.browserAdapter = browserImpl;
        this.browserAdapterId = browserAdapterId;
        this.external = externalBrowser;
    }

    @Override
    public void close() {
        this.browserAdapter.close();
    }

    @Override
    public boolean isCloseSupported() {
        return this.browserAdapter.isCloseSupported();
    }

    @Override
    public void displayURL(String url) throws Exception {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapter != null) {
            this.browserAdapter.close();
            this.browserAdapter = this.newBrowserAdapter;
            this.newBrowserAdapter = null;
            this.browserAdapterId = this.newBrowserAdapterId;
            this.newBrowserAdapterId = null;
            if (this.locationSet) {
                this.browserAdapter.setLocation(this.x, this.y);
            }
            if (this.sizeSet) {
                this.browserAdapter.setSize(this.width, this.height);
            }
        }
        this.browserAdapter.displayURL(url);
    }

    @Override
    public boolean isSetLocationSupported() {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapterId == null) {
            return this.browserAdapter.isSetLocationSupported();
        }
        return this.browserAdapter.isSetLocationSupported() || this.newBrowserAdapter.isSetLocationSupported();
    }

    @Override
    public boolean isSetSizeSupported() {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapterId == null) {
            return this.browserAdapter.isSetSizeSupported();
        }
        return this.browserAdapter.isSetSizeSupported() || this.newBrowserAdapter.isSetSizeSupported();
    }

    @Override
    public void setLocation(int x, int y) {
        this.checkDefaultAdapter();
        this.browserAdapter.setLocation(x, y);
        this.locationSet = true;
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.checkDefaultAdapter();
        this.browserAdapter.setSize(width, height);
        this.sizeSet = true;
        this.width = width;
        this.height = height;
    }

    private void checkDefaultAdapter() {
        if (this.external) {
            if (!this.browserAdapterId.equals(BrowserManager.getInstance().getCurrentBrowserID())) {
                this.newBrowserAdapter = BrowserManager.getInstance().createBrowser(true);
                this.newBrowserAdapterId = BrowserManager.getInstance().getCurrentBrowserID();
            }
        } else if (!this.browserAdapterId.equals(BrowserManager.getInstance().getCurrentInternalBrowserID())) {
            this.newBrowserAdapter = BrowserManager.getInstance().createBrowser(false);
            this.newBrowserAdapterId = BrowserManager.getInstance().getCurrentInternalBrowserID();
        }
    }
}

