/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;

public class RelativeToBorderLocator
implements Locator {
    private int margin;
    protected int direction;
    protected IFigure reference;

    public RelativeToBorderLocator(IFigure reference, int direction, int margin) {
        this.reference = reference;
        this.direction = direction;
        this.margin = margin;
    }

    public void relocate(IFigure target) {
        PrecisionRectangle bounds = this.reference instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)this.reference).getHandleBounds()) : new PrecisionRectangle(this.reference.getBounds());
        this.reference.translateToAbsolute((Translatable)bounds);
        target.translateToRelative((Translatable)bounds);
        int width = target.getBounds().width;
        int halfWidth = width / 2;
        int height = target.getBounds().height;
        int halfHeight = height / 2;
        if (this.direction == 2) {
            Dimension shift = new Dimension(-halfWidth, -halfHeight);
            target.setLocation(bounds.getCenter().getTranslated(shift));
        } else if (this.margin < 0) {
            if (this.direction == 9) {
                Dimension shift = new Dimension(-this.margin, -this.margin);
                target.setLocation(bounds.getTopLeft().getTranslated(shift));
            } else if (this.direction == 1) {
                Dimension shift = new Dimension(-halfWidth, -this.margin);
                target.setLocation(bounds.getTop().getTranslated(shift));
            } else if (this.direction == 17) {
                Dimension shift = new Dimension(-(width + -this.margin), -this.margin);
                target.setLocation(bounds.getTopRight().getTranslated(shift));
            } else if (this.direction == 12) {
                Dimension shift = new Dimension(-this.margin, -(height + -this.margin));
                target.setLocation(bounds.getBottomLeft().getTranslated(shift));
            } else if (this.direction == 4) {
                Dimension shift = new Dimension(-halfWidth, -(height + -this.margin));
                target.setLocation(bounds.getBottom().getTranslated(shift));
            } else if (this.direction == 20) {
                Dimension shift = new Dimension(-(width + -this.margin), -(height + -this.margin));
                target.setLocation(bounds.getBottomRight().getTranslated(shift));
            } else if (this.direction == 8) {
                Dimension shift = new Dimension(-this.margin, -halfHeight);
                target.setLocation(bounds.getLeft().getTranslated(shift));
            } else if (this.direction == 16) {
                Dimension shift = new Dimension(-(width + -this.margin), -halfHeight);
                target.setLocation(bounds.getRight().getTranslated(shift));
            }
        } else if (this.direction == 9) {
            Dimension shift = new Dimension(-(width + this.margin), -(height + this.margin));
            target.setLocation(bounds.getTopLeft().getTranslated(shift));
        } else if (this.direction == 1) {
            Dimension shift = new Dimension(-halfWidth, -(height + this.margin));
            target.setLocation(bounds.getTop().getTranslated(shift));
        } else if (this.direction == 17) {
            Dimension shift = new Dimension(this.margin, -(height + this.margin));
            target.setLocation(bounds.getTopRight().getTranslated(shift));
        } else if (this.direction == 12) {
            Dimension shift = new Dimension(-(width + this.margin), this.margin);
            target.setLocation(bounds.getBottomLeft().getTranslated(shift));
        } else if (this.direction == 4) {
            Dimension shift = new Dimension(-halfWidth, this.margin);
            target.setLocation(bounds.getBottom().getTranslated(shift));
        } else if (this.direction == 20) {
            Dimension shift = new Dimension(this.margin, this.margin);
            target.setLocation(bounds.getBottomRight().getTranslated(shift));
        } else if (this.direction == 8) {
            Dimension shift = new Dimension(-(width + this.margin), -halfHeight);
            target.setLocation(bounds.getLeft().getTranslated(shift));
        } else if (this.direction == 16) {
            Dimension shift = new Dimension(this.margin, -halfHeight);
            target.setLocation(bounds.getRight().getTranslated(shift));
        }
    }
}

