/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.viewpoint;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallbackWithConfimation;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ViewpointSelectionCallbackWithConfimationAndDependenciesHandling
extends ViewpointSelectionCallbackWithConfimation {
    private boolean askUserForDependencyActivation;

    public ViewpointSelectionCallbackWithConfimationAndDependenciesHandling(boolean doAskUserForDependencyActivation) {
        this.askUserForDependencyActivation = doAskUserForDependencyActivation;
    }

    public ViewpointSelectionCallbackWithConfimationAndDependenciesHandling() {
        this(true);
    }

    @Override
    public void deselectViewpoint(Viewpoint deactivatedViewpoint, Session session, Set<Viewpoint> allViewpointToDeactivate, IProgressMonitor monitor) {
        boolean confirmDeactivation;
        Set<Viewpoint> additionalViewpointToDeactivate = ViewpointHelper.getAdditionalViewpointsToDeactivate(deactivatedViewpoint, session).stream().filter(vp -> this.viewpointWillNotBeDeactivatedInSession(session, allViewpointToDeactivate, (Viewpoint)vp)).collect(Collectors.toSet());
        boolean bl = confirmDeactivation = !additionalViewpointToDeactivate.isEmpty() && (!this.askUserForDependencyActivation || this.askUserForDependencyActivation && this.userConfirmsDependenciesActivationStatusChange(deactivatedViewpoint, additionalViewpointToDeactivate, false));
        if (additionalViewpointToDeactivate.isEmpty() || confirmDeactivation) {
            for (Viewpoint viewpointToDeactivate : additionalViewpointToDeactivate) {
                this.deselectViewpoint(viewpointToDeactivate, session, monitor);
            }
            super.deselectViewpoint(deactivatedViewpoint, session, monitor);
        }
    }

    private boolean viewpointWillNotBeDeactivatedInSession(Session session, Set<Viewpoint> allViewpointToDeactivate, Viewpoint vp) {
        boolean alreadyDeactivated = false;
        for (Viewpoint desactivatedViewpoint : allViewpointToDeactivate) {
            if (!EqualityHelper.areEquals((EObject)vp, (EObject)desactivatedViewpoint)) continue;
            alreadyDeactivated = true;
        }
        boolean isActivatedInSession = false;
        for (Viewpoint activatedViewpoint : session.getSelectedViewpoints(false)) {
            if (!EqualityHelper.areEquals((EObject)vp, (EObject)activatedViewpoint)) continue;
            isActivatedInSession = true;
        }
        alreadyDeactivated = alreadyDeactivated || !isActivatedInSession;
        return !alreadyDeactivated;
    }

    @Override
    public void selectViewpoint(Viewpoint viewpoint, Session session, boolean createNewRepresentations, Set<Viewpoint> allSelectedViewpoint, IProgressMonitor monitor) {
        boolean allDependenciesAvailable;
        Map<String, Viewpoint> viewpointDependencies = ViewpointHelper.getViewpointDependencies(ViewpointHelper.getAvailableViewpoints(session), allSelectedViewpoint, viewpoint);
        boolean bl = allDependenciesAvailable = viewpointDependencies.isEmpty() || viewpointDependencies.values().stream().allMatch(vp -> vp != null);
        if (allDependenciesAvailable) {
            boolean confirmActivation;
            Map<String, Viewpoint> viewpointDependenciesToActivateMap = viewpointDependencies.entrySet().stream().filter(entry -> this.viewpointWillNotBeActivatedInSession(session, allSelectedViewpoint, (Viewpoint)entry.getValue())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Viewpoint)entry.getValue()));
            boolean bl2 = confirmActivation = viewpointDependenciesToActivateMap.isEmpty() || !this.askUserForDependencyActivation || this.askUserForDependencyActivation && this.userConfirmsDependenciesActivationStatusChange(viewpoint, viewpointDependenciesToActivateMap.values(), true);
            if (confirmActivation) {
                for (Viewpoint viewpointToActivate : viewpointDependenciesToActivateMap.values()) {
                    this.selectViewpoint(viewpointToActivate, session, createNewRepresentations, monitor);
                }
                super.selectViewpoint(viewpoint, session, createNewRepresentations, monitor);
            }
        } else {
            this.informUserViewpointActivationFailed(viewpoint, viewpointDependencies);
        }
    }

    private boolean viewpointWillNotBeActivatedInSession(Session session, Set<Viewpoint> allSelectedViewpoint, Viewpoint vp) {
        boolean alreadyActivated = false;
        for (Viewpoint desactivatedViewpoint : allSelectedViewpoint) {
            if (!EqualityHelper.areEquals((EObject)vp, (EObject)desactivatedViewpoint)) continue;
            alreadyActivated = true;
        }
        boolean isActivatedInSession = false;
        for (Viewpoint activatedViewpoint : session.getSelectedViewpoints(false)) {
            if (!EqualityHelper.areEquals((EObject)vp, (EObject)activatedViewpoint)) continue;
            isActivatedInSession = true;
        }
        alreadyActivated = alreadyActivated || isActivatedInSession;
        return !alreadyActivated;
    }

    private void informUserViewpointActivationFailed(final Viewpoint viewpoint, final Map<String, Viewpoint> missingDependenciesMap) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String missingDependenciesList = missingDependenciesMap.entrySet().stream().filter(entry -> entry.getValue() == null).map(entry -> (String)entry.getKey()).collect(Collectors.joining(", "));
                String message = MessageFormat.format(Messages.ViewpointSelectionCallbackWithConfimationAndDependenciesHandling_missingDependency_message, viewpoint.getName(), missingDependenciesList);
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ViewpointSelectionCallbackWithConfimationAndDependenciesHandling_missingDependency_title, (String)message);
            }
        });
    }

    private boolean userConfirmsDependenciesActivationStatusChange(Viewpoint viewpoint, Collection<Viewpoint> dependencies, boolean activate) {
        String viewpointList = dependencies.stream().map(vp -> vp.getName()).collect(Collectors.joining(new StringBuilder(", ")));
        String activationStatusLabel = activate ? Messages.ViewpointSelectionCallbackWithConfimationAndDependenciesHandling_confirmDependencyActivation_activateLabel : Messages.ViewpointSelectionCallbackWithConfimationAndDependenciesHandling_confirmDependencyActivation_deactivateLabel;
        final String message = MessageFormat.format(Messages.ViewpointSelectionCallbackWithConfimationAndDependenciesHandling_confirmDependencyActivation_message, viewpoint.getName(), activationStatusLabel, viewpointList);
        final AtomicBoolean confirmation = new AtomicBoolean(false);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                confirmation.set(MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ViewpointSelectionCallbackWithConfimationAndDependenciesHandling_confirmDependencyActivation_title, (String)message));
            }
        });
        return confirmation.get();
    }
}

