/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationManagerDescriptor;

public final class ModelOperationManagerRegistry {
    private static final List<ModelOperationManagerDescriptor> EXTENSIONS = new ArrayList<ModelOperationManagerDescriptor>();
    private static final Map<String, ModelOperationManagerDescriptor> ID_TO_DESCRIPTOR_MAP = new HashMap<String, ModelOperationManagerDescriptor>();

    private ModelOperationManagerRegistry() {
    }

    public static void addExtension(ModelOperationManagerDescriptor extension) {
        EXTENSIONS.add(extension);
        ID_TO_DESCRIPTOR_MAP.put(extension.getId(), extension);
    }

    public static List<ModelOperationManagerDescriptor> getRegisteredExtensions() {
        return new ArrayList<ModelOperationManagerDescriptor>(EXTENSIONS);
    }

    public static void removeExtension(String id) {
        for (ModelOperationManagerDescriptor extension : ModelOperationManagerRegistry.getRegisteredExtensions()) {
            if (!extension.getId().equals(id)) continue;
            EXTENSIONS.remove(extension);
            ID_TO_DESCRIPTOR_MAP.remove(extension.getId());
        }
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
        ID_TO_DESCRIPTOR_MAP.clear();
    }
}

