/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.facets;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppClientVersionChangeDelegate
implements IDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(AppClientVersionChangeDelegate.class);

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (cfg == null) {
            return;
        }
        if (monitor != null) {
            monitor.beginTask("Updating Application Client facet version", 1);
        }
        try {
            IVirtualComponent c;
            Path appClientContent;
            IDataModel model = (IDataModel)cfg;
            if (monitor != null) {
                monitor.worked(1);
            }
            if (!WTPProjectsUtil.hasLink(project, (IPath)new Path("/"), (IPath)(appClientContent = new Path("/" + model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER"))), monitor) && (c = ComponentCore.createComponent((IProject)project, (boolean)true)) != null) {
                IVirtualFolder root = c.getRootFolder();
                root.createLink((IPath)appClientContent, 0, null);
            }
            try {
                ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
            }
            catch (ExecutionException e) {
                LOG.error("Unable to notify Application Client version change", (Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

