/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.modulecore;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.m2e.wtp.overlay.internal.utilities.CompressionUtil;

public class UnpackArchiveJob
extends WorkspaceJob {
    private IFolder unpackFolder;
    private File archive;

    public UnpackArchiveJob(String name, File archive, IFolder unpackFolder) {
        super(name);
        assert (unpackFolder != null);
        assert (archive != null && archive.exists() && archive.canRead());
        this.unpackFolder = unpackFolder;
        this.archive = archive;
        this.setRule((ISchedulingRule)unpackFolder);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            if (this.unpackFolder.exists()) {
                IResource[] members;
                IResource[] iResourceArray = members = this.unpackFolder.members(10);
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    member.delete(true, monitor);
                    ++n2;
                }
            }
            this.unpack(this.archive, this.unpackFolder.getLocation().toOSString(), monitor);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.m2e.wtp.overlay", "Error unpacking " + this.archive.getName(), (Throwable)e);
        }
        catch (InterruptedException e) {
            return new Status(4, "org.eclipse.m2e.wtp.overlay", "Unpacking " + this.archive.getName() + " was interrupted", (Throwable)e);
        }
        new WorkspaceJob(String.valueOf(this.unpackFolder.getLocation().toString()) + " refresher"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                UnpackArchiveJob.this.unpackFolder.refreshLocal(2, null);
                return Status.OK_STATUS;
            }
        }.schedule();
        return Status.OK_STATUS;
    }

    protected void unpack(File archive, String unpackFolderPath, IProgressMonitor monitor) throws IOException, CoreException, InterruptedException {
        File unpackFolder = new File(unpackFolderPath);
        CompressionUtil.unzip(archive, unpackFolder, monitor);
        unpackFolder.setLastModified(archive.lastModified());
    }
}

