/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jaxrs.internal.configurators;

import java.io.File;
import java.util.Collection;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSFacetInstallDataModelProvider;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.jaxrs.internal.MavenJaxRsConstants;
import org.eclipse.m2e.wtp.jaxrs.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRsProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String WAR_PACKAGING = "war";
    private static final Logger LOG = LoggerFactory.getLogger(JaxRsProjectConfigurator.class);

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.configureInternal(mavenProject, project, monitor);
    }

    private void configureInternal(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        if (!WAR_PACKAGING.equals(mavenProject.getPackaging())) {
            return;
        }
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj == null) {
            return;
        }
        if (!fproj.hasProjectFacet(WTPProjectsUtil.DYNAMIC_WEB_FACET) || fproj.hasProjectFacet(MavenJaxRsConstants.JAX_RS_FACET)) {
            return;
        }
        IProjectFacetVersion jaxRsVersion = this.getJaxRsVersion(project);
        if (jaxRsVersion != null) {
            this.installJaxRsFacet(fproj, jaxRsVersion, mavenProject, monitor);
        }
    }

    private void installJaxRsFacet(IFacetedProject fproj, IProjectFacetVersion facetVersion, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        this.markerManager.deleteMarkers((IResource)fproj.getProject(), "org.eclipse.m2e.core.maven2Problem.wtp.jaxrs.configuration");
        IStatus status = facetVersion.getConstraint().check((Collection)fproj.getProjectFacets());
        if (status.isOK()) {
            ProjectUtils.refreshHierarchy((File)mavenProject.getBasedir(), (int)2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IDataModel model = this.createJaxRsDataModel(fproj, facetVersion);
            WarPluginConfiguration warConfig = new WarPluginConfiguration(mavenProject, fproj.getProject());
            String warSourceDirectory = warConfig.getWarSourceDirectory();
            model.setProperty("IJAXRSFacetInstallDataModelProperties.WEBCONTENT_DIR", (Object)warSourceDirectory);
            model.setProperty("IJAXRSFacetInstallDataModelProperties.UPDATEDD", (Object)false);
            fproj.installProjectFacet(facetVersion, (Object)model, monitor);
        } else {
            String errorMessage = status.getMessage() == null ? "<unknown error>" : status.getMessage();
            String markerMessage = NLS.bind((String)Messages.JaxrsProjectConfigurator_facet_cannot_be_installed, (Object)facetVersion, (Object)errorMessage);
            this.addErrorMarker(fproj.getProject(), markerMessage);
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus st = iStatusArray[n2];
                this.addErrorMarker(fproj.getProject(), st.getMessage());
                ++n2;
            }
        }
    }

    private IDataModel createJaxRsDataModel(IFacetedProject fproj, IProjectFacetVersion facetVersion) {
        IDataModel config = (IDataModel)new JAXRSFacetInstallDataModelProvider().create();
        LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fproj, facetVersion);
        ILibraryProvider provider = LibraryProviderFramework.getProvider((String)"jaxrs-no-op-library-provider");
        libraryDelegate.setLibraryProvider(provider);
        config.setProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE", (Object)libraryDelegate);
        return config;
    }

    private IProjectFacetVersion getJaxRsVersion(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IType type = null;
            try {
                type = javaProject.findType("javax.ws.rs.ApplicationPath");
                if (type != null) {
                    return MavenJaxRsConstants.JAX_RS_FACET_1_1;
                }
                type = javaProject.findType("javax.ws.rs.Path");
                if (type != null) {
                    return MavenJaxRsConstants.JAX_RS_FACET_1_0;
                }
            }
            catch (JavaModelException e) {
                LOG.error("Unable to determine JAX-RS version", (Throwable)e);
            }
        }
        return null;
    }

    private void addErrorMarker(IProject project, String message) {
        this.markerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.jaxrs.configuration", message, -1, 2);
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (facade != null) {
            IProject project = facade.getProject();
            MavenProject mavenProject = facade.getMavenProject(monitor);
            if (WTPProjectsUtil.isWTPProject((IProject)project) && WAR_PACKAGING.equals(mavenProject.getPackaging())) {
                MavenProject oldProject;
                IMavenProjectFacade oldFacade = event.getOldMavenProject();
                if (oldFacade != null && (oldProject = oldFacade.getMavenProject(monitor)) != null && oldProject.getArtifacts().equals(mavenProject.getArtifacts())) {
                    return;
                }
                this.configureInternal(mavenProject, project, monitor);
            }
        }
    }
}

