/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jsf.internal.configurators;

import java.io.File;
import java.util.Collection;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetInstallDataModelProvider;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.jsf.internal.MavenJSFConstants;
import org.eclipse.m2e.wtp.jsf.internal.utils.JSFUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JSFProjectConfigurator
extends AbstractProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.configureInternal(mavenProject, project, monitor);
    }

    private void configureInternal(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        if (!"war".equals(mavenProject.getPackaging())) {
            return;
        }
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj != null) {
            if (fproj.hasProjectFacet(MavenJSFConstants.JSF_FACET)) {
                return;
            }
            IProjectFacetVersion jsfVersion = this.getJSFVersion(mavenProject, fproj);
            if (fproj != null && jsfVersion != null) {
                this.installJSFFacet(fproj, mavenProject, jsfVersion, monitor);
            }
        }
    }

    private void installJSFFacet(IFacetedProject fproj, MavenProject mavenProject, IProjectFacetVersion facetVersion, IProgressMonitor monitor) throws CoreException {
        this.markerManager.deleteMarkers((IResource)fproj.getProject(), "org.eclipse.m2e.core.maven2Problem.wtp.jsf.configuration");
        if (fproj.hasProjectFacet(IJ2EEFacetConstants.DYNAMIC_WEB_FACET) && !fproj.hasProjectFacet(MavenJSFConstants.JSF_FACET)) {
            IProject project = fproj.getProject();
            ProjectUtils.refreshHierarchy((File)mavenProject.getBasedir(), (int)2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            WarPluginConfiguration warConfig = new WarPluginConfiguration(mavenProject, project);
            IFolder warSourceDir = project.getFolder(warConfig.getWarSourceDirectory());
            Path facesConfigPath = new Path("WEB-INF/faces-config.xml");
            IFile defaultFacesConfig = warSourceDir.getFile((IPath)facesConfigPath);
            IFolder generatedWebResourcesFolder = ProjectUtils.getGeneratedWebResourcesFolder((MavenProject)mavenProject, (IProject)project);
            IFile generatedFacesConfig = generatedWebResourcesFolder.getFile((IPath)facesConfigPath);
            ResourceCleaner cleaner = new ResourceCleaner(project);
            cleaner.addFolder(warSourceDir.getFolder("WEB-INF/lib"));
            cleaner.addFiles(new IFile[]{defaultFacesConfig, generatedFacesConfig});
            IStatus status = facetVersion.getConstraint().check((Collection)fproj.getProjectFacets());
            try {
                if (status.isOK()) {
                    IDataModel model = this.createJSFDataModel(fproj, facetVersion);
                    model.setBooleanProperty("IJSFFacetInstallDataModelProperties.CONFIGURE_SERVLET", false);
                    fproj.installProjectFacet(facetVersion, (Object)model, monitor);
                } else {
                    this.addErrorMarker(fproj.getProject(), facetVersion + " can not be installed : " + status.getMessage());
                    IStatus[] iStatusArray = status.getChildren();
                    int n = iStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus st = iStatusArray[n2];
                        this.addErrorMarker(fproj.getProject(), st.getMessage());
                        ++n2;
                    }
                }
            }
            finally {
                cleaner.cleanUp();
            }
        }
    }

    private void addErrorMarker(IProject project, String message) {
        this.markerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.jsf.configuration", message, -1, 2);
    }

    private IProjectFacetVersion getJSFVersion(MavenProject mavenProject, IFacetedProject fproj) {
        String version = null;
        IProject project = fproj.getProject();
        version = JSFUtils.getVersionFromFacesconfig(project);
        if (version == null) {
            version = JSFUtils.getJSFVersionFromClasspath(project);
        }
        if (version == null && this.hasFacesServletInWebXml(mavenProject, project)) {
            IProjectFacetVersion webVersion = fproj.getInstalledVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            version = webVersion.compareTo((Object)IJ2EEFacetConstants.DYNAMIC_WEB_30) < 0 ? "1.2" : "2.0";
        }
        IProjectFacetVersion facetVersion = null;
        if (version != null) {
            if (version.startsWith("1.1")) {
                facetVersion = MavenJSFConstants.JSF_FACET_VERSION_1_1;
            } else if (version.startsWith("1.2")) {
                facetVersion = MavenJSFConstants.JSF_FACET_VERSION_1_2;
            } else if (version.startsWith("2.0")) {
                facetVersion = MavenJSFConstants.JSF_FACET_VERSION_2_0;
            } else if (version.startsWith("2.1")) {
                facetVersion = MavenJSFConstants.JSF_FACET_VERSION_2_1;
            }
        }
        return facetVersion;
    }

    private boolean hasFacesServletInWebXml(MavenProject mavenProject, IProject project) {
        IFile webXml = ProjectUtils.getWebResourceFile((IProject)project, (String)"WEB-INF/web.xml");
        return webXml != null && webXml.exists() && JSFUtils.hasFacesServlet(webXml);
    }

    private IDataModel createJSFDataModel(IFacetedProject fproj, IProjectFacetVersion facetVersion) {
        IDataModel config = (IDataModel)new JSFFacetInstallDataModelProvider().create();
        LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fproj, facetVersion);
        ILibraryProvider provider = LibraryProviderFramework.getProvider((String)"jsf-no-op-library-provider");
        libraryDelegate.setLibraryProvider(provider);
        config.setProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE", (Object)libraryDelegate);
        config.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME", (Object)"");
        config.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", (Object)new String[0]);
        return config;
    }
}

