/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.jca.project.facet.ConnectorFacetInstallDataModelProvider;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.wtp.AbstractProjectConfiguratorDelegate;
import org.eclipse.m2e.wtp.ArtifactHelper;
import org.eclipse.m2e.wtp.RarPluginConfiguration;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.namemapping.FileNameMappingFactory;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

class ConnectorProjectConfiguratorDelegate
extends AbstractProjectConfiguratorDelegate {
    public static final ArtifactFilter SCOPE_FILTER_RUNTIME = new ScopeArtifactFilter("runtime");

    ConnectorProjectConfiguratorDelegate() {
    }

    @Override
    protected void configure(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        if (facetedProject == null) {
            return;
        }
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        this.installJavaFacet(actions, project, facetedProject);
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
        RarPluginConfiguration config = new RarPluginConfiguration(facade);
        String contentDir = config.getRarContentDirectory();
        IProjectFacetVersion connectorFv = config.getConnectorFacetVersion();
        IDataModel rarModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorFacetInstallDataModelProvider());
        IFolder contentFolder = project.getFolder(contentDir);
        if (!facetedProject.hasProjectFacet(WTPProjectsUtil.JCA_FACET)) {
            rarModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)contentDir);
            rarModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", (Object)false);
            WTPProjectsUtil.removeConflictingFacets(facetedProject, connectorFv, actions);
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, connectorFv, (Object)rarModelCfg));
        } else {
            IProjectFacetVersion projectFacetVersion = facetedProject.getProjectFacetVersion(WTPProjectsUtil.JCA_FACET);
            if (projectFacetVersion.getVersionString() != null && !projectFacetVersion.getVersionString().equals(projectFacetVersion.getVersionString())) {
                WTPProjectsUtil.removeConflictingFacets(facetedProject, connectorFv, actions);
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, connectorFv, (Object)rarModelCfg));
            }
        }
        String customRaXml = config.getCustomRaXml();
        if (!actions.isEmpty()) {
            ResourceCleaner fileCleaner = new ResourceCleaner(project);
            try {
                this.addFoldersToClean(fileCleaner, facade);
                fileCleaner.addFiles(contentFolder.getFile("META-INF/MANIFEST.MF").getProjectRelativePath());
                if (customRaXml != null) {
                    fileCleaner.addFiles(contentFolder.getFile("META-INF/ra.xml").getProjectRelativePath());
                }
                facetedProject.modify(actions, monitor);
            }
            finally {
                fileCleaner.cleanUp();
            }
        }
        this.fixMissingModuleCoreNature(project, monitor);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            if (config.isJarIncluded()) {
                this.addSourceLinks(component, mavenProject, monitor);
            } else {
                this.removeSourceLinks(component, mavenProject, monitor);
            }
            this.removeTestFolderLinks(project, mavenProject, monitor, "/");
            this.linkFileFirst(project, customRaXml, "META-INF/ra.xml", monitor);
            IPath contentDirPath = new Path("/").append(contentDir);
            if (!WTPProjectsUtil.hasLink(project, ROOT_PATH, contentDirPath, monitor)) {
                component.getRootFolder().createLink(contentDirPath, 0, monitor);
            }
            WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(component.getRootFolder(), contentDirPath, monitor);
        }
        this.setNonDependencyAttributeToContainer(project, monitor);
        WTPProjectsUtil.removeWTPClasspathContainer(project);
    }

    private void addSourceLinks(IVirtualComponent component, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IProject project = component.getProject();
        IPath classesPath = MavenProjectUtils.getProjectRelativePath((IProject)project, (String)mavenProject.getBuild().getOutputDirectory());
        if (classesPath != null) {
            IPath location;
            IPath[] iPathArray = MavenProjectUtils.getSourceLocations((IProject)project, (List)mavenProject.getCompileSourceRoots());
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                location = iPathArray[n2];
                this.addLinkIfNecessary(component, location, monitor);
                ++n2;
            }
            iPathArray = MavenProjectUtils.getResourceLocations((IProject)project, (List)mavenProject.getResources());
            n = iPathArray.length;
            n2 = 0;
            while (n2 < n) {
                location = iPathArray[n2];
                this.addLinkIfNecessary(component, location, monitor);
                ++n2;
            }
        }
    }

    private void addLinkIfNecessary(IVirtualComponent component, IPath location, IProgressMonitor monitor) throws CoreException {
        IProject project = component.getProject();
        if (location != null && !WTPProjectsUtil.hasLink(project, ROOT_PATH, location, monitor) && project.getFolder(location).isAccessible()) {
            component.getRootFolder().createLink(location, 0, monitor);
        }
    }

    private void removeSourceLinks(IVirtualComponent component, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IPath location;
        IVirtualFolder jsrc = component.getRootFolder();
        IProject project = component.getProject();
        IPath[] iPathArray = MavenProjectUtils.getSourceLocations((IProject)project, (List)mavenProject.getCompileSourceRoots());
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            location = iPathArray[n2];
            jsrc.removeLink(location, 0, monitor);
            ++n2;
        }
        iPathArray = MavenProjectUtils.getResourceLocations((IProject)project, (List)mavenProject.getResources());
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            location = iPathArray[n2];
            jsrc.removeLink(location, 0, monitor);
            ++n2;
        }
    }

    @Override
    public void setModuleDependencies(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent rarComponent = ComponentCore.createComponent((IProject)project);
        LinkedHashSet<IVirtualReference> newRefs = new LinkedHashSet<IVirtualReference>();
        Set artifacts = mavenProject.getArtifacts();
        for (Artifact artifact : artifacts) {
            ArtifactHelper.fixArtifactHandler(artifact.getArtifactHandler());
            if ("pom".equals(artifact.getType()) || !SCOPE_FILTER_RUNTIME.include(artifact) || artifact.isOptional()) continue;
            IMavenProjectFacade workspaceDependency = this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            if (workspaceDependency != null && !workspaceDependency.getProject().equals((Object)project) && workspaceDependency.getFullPath(artifact.getFile()) != null) {
                IProject depProject = this.preConfigureDependencyProject(workspaceDependency, monitor);
                if (!ModuleCoreNature.isFlexibleProject((IProject)depProject)) continue;
                newRefs.add(this.createReference(rarComponent, depProject, artifact));
                continue;
            }
            newRefs.add(this.createReference(rarComponent, artifact));
        }
        IVirtualReference[] newRefsArray = new IVirtualReference[newRefs.size()];
        newRefs.toArray(newRefsArray);
        IVirtualReference[] references = WTPProjectsUtil.extractHardReferences(rarComponent, false);
        if (WTPProjectsUtil.hasChanged(references, newRefsArray)) {
            rarComponent.setReferences(newRefsArray);
        }
    }

    private IVirtualReference createReference(IVirtualComponent rarComponent, IProject project, Artifact artifact) {
        IVirtualComponent depComponent = ComponentCore.createComponent((IProject)project);
        IVirtualReference depRef = ComponentCore.createReference((IVirtualComponent)rarComponent, (IVirtualComponent)depComponent);
        String deployedFileName = FileNameMappingFactory.getDefaultFileNameMapping().mapFileName(artifact);
        depRef.setArchiveName(deployedFileName);
        return depRef;
    }

    private IVirtualReference createReference(IVirtualComponent rarComponent, Artifact artifact) {
        String artifactPath = ArtifactHelper.getM2REPOVarPath(artifact);
        IVirtualComponent depComponent = ComponentCore.createArchiveComponent((IProject)rarComponent.getProject(), (String)artifactPath);
        return ComponentCore.createReference((IVirtualComponent)rarComponent, (IVirtualComponent)depComponent);
    }
}

