/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.overlay.InvalidOverlayConfigurationException;
import org.apache.maven.plugin.war.overlay.OverlayManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.wtp.AbstractFilteringSupportMavenPlugin;
import org.eclipse.m2e.wtp.DomUtils;
import org.eclipse.m2e.wtp.IMavenPackageFilter;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.StringUtils;
import org.eclipse.m2e.wtp.namemapping.FileNameMapping;
import org.eclipse.m2e.wtp.namemapping.PatternBasedFileNameMapping;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class WarPluginConfiguration
extends AbstractFilteringSupportMavenPlugin
implements IMavenPackageFilter {
    private static final String WAR_SOURCE_FOLDER = "/src/main/webapp";
    private static final String WAR_PACKAGING = "war";
    private static final String WEB_XML = "WEB-INF/web.xml";
    private IProject project;
    private MavenProject mavenProject;

    public WarPluginConfiguration(MavenProject mavenProject, IProject project) {
        this.project = project;
        this.mavenProject = mavenProject;
        Plugin plugin = this.getPlugin();
        this.setConfiguration((Xpp3Dom)plugin.getConfiguration());
    }

    public Plugin getPlugin() {
        return this.mavenProject.getPlugin("org.apache.maven.plugins:maven-war-plugin");
    }

    static boolean isWarProject(MavenProject mavenProject) {
        return WAR_PACKAGING.equals(mavenProject.getPackaging());
    }

    public Xpp3Dom[] getWebResources() {
        Xpp3Dom webResources;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (webResources = config.getChild("webResources")) != null && webResources.getChildCount() > 0) {
            int count = webResources.getChildCount();
            Xpp3Dom[] resources = new Xpp3Dom[count];
            int i = 0;
            while (i < count) {
                Xpp3Dom webResource = new Xpp3Dom(webResources.getChild(i), "resource");
                Xpp3Dom targetPath = webResource.getChild("targetPath");
                if (targetPath != null && targetPath.getValue().startsWith("/")) {
                    targetPath.setValue(targetPath.getValue().substring(1));
                }
                resources[i] = webResource;
                ++i;
            }
            return resources;
        }
        return new Xpp3Dom[0];
    }

    public String getWarSourceDirectory() {
        Xpp3Dom dom = this.getConfiguration();
        if (dom == null) {
            return WAR_SOURCE_FOLDER;
        }
        Xpp3Dom[] warSourceDirectory = dom.getChildren("warSourceDirectory");
        if (warSourceDirectory != null && warSourceDirectory.length > 0) {
            String dir = warSourceDirectory[0].getValue();
            if (this.project != null) {
                return WTPProjectsUtil.tryProjectRelativePath(this.project, dir).toOSString();
            }
            return dir;
        }
        return WAR_SOURCE_FOLDER;
    }

    @Override
    public String[] getPackagingExcludes() {
        return DomUtils.getPatternsAsArray(this.getConfiguration(), "packagingExcludes");
    }

    @Override
    public String[] getPackagingIncludes() {
        return DomUtils.getPatternsAsArray(this.getConfiguration(), "packagingIncludes");
    }

    @Override
    public String[] getSourceExcludes() {
        return DomUtils.getPatternsAsArray(this.getConfiguration(), "warSourceExcludes");
    }

    @Override
    public String[] getSourceIncludes() {
        return DomUtils.getPatternsAsArray(this.getConfiguration(), "warSourceIncludes");
    }

    public boolean isAddManifestClasspath() {
        Xpp3Dom addToClp;
        Xpp3Dom manifest;
        Xpp3Dom arch;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (arch = config.getChild("archive")) != null && (manifest = arch.getChild("manifest")) != null && (addToClp = manifest.getChild("addClasspath")) != null) {
            return Boolean.valueOf(addToClp.getValue());
        }
        return false;
    }

    public String getManifestClasspathPrefix() {
        Xpp3Dom prefix;
        Xpp3Dom manifest;
        Xpp3Dom arch;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (arch = config.getChild("archive")) != null && (manifest = arch.getChild("manifest")) != null && (prefix = manifest.getChild("classpathPrefix")) != null && !StringUtils.nullOrEmpty(prefix.getValue())) {
            String rawPrefix = prefix.getValue().trim();
            if (!rawPrefix.endsWith("/")) {
                rawPrefix = String.valueOf(rawPrefix) + "/";
            }
            return rawPrefix;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProjectFacetVersion getWebFacetVersion(IProject project) {
        String customWebXml = this.getCustomWebXml(project);
        IFile webXml = customWebXml == null ? project.getFolder(this.getWarSourceDirectory()).getFile(WEB_XML) : project.getFile(customWebXml);
        if (webXml.isAccessible()) {
            try {
                InputStream is = webXml.getContents();
                try {
                    JavaEEQuickPeek jqp = new JavaEEQuickPeek(is);
                    switch (jqp.getVersion()) {
                        case 22: {
                            IProjectFacetVersion iProjectFacetVersion = WebFacetUtils.WEB_22;
                            return iProjectFacetVersion;
                        }
                        case 23: {
                            IProjectFacetVersion iProjectFacetVersion = WebFacetUtils.WEB_23;
                            return iProjectFacetVersion;
                        }
                        case 24: {
                            IProjectFacetVersion iProjectFacetVersion = WebFacetUtils.WEB_24;
                            return iProjectFacetVersion;
                        }
                        case 25: {
                            IProjectFacetVersion iProjectFacetVersion = WebFacetUtils.WEB_25;
                            return iProjectFacetVersion;
                        }
                        case 30: {
                            IProjectFacetVersion iProjectFacetVersion = WebFacetUtils.WEB_30;
                            return iProjectFacetVersion;
                        }
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        if (!WTPProjectsUtil.hasInClassPath(project, "javax.servlet.annotation.WebServlet")) return WTPProjectsUtil.DEFAULT_WEB_FACET;
        return WebFacetUtils.WEB_30;
    }

    public String getCustomWebXml(IProject project) {
        Xpp3Dom webXmlDom;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (webXmlDom = config.getChild("webXml")) != null && webXmlDom.getValue() != null) {
            String webXmlFile = webXmlDom.getValue().trim();
            webXmlFile = ProjectUtils.getRelativePath(project, webXmlFile);
            return webXmlFile;
        }
        return null;
    }

    public List<Overlay> getOverlays() throws CoreException {
        Overlay currentProjectOverlay = Overlay.createInstance();
        currentProjectOverlay.setArtifact(this.mavenProject.getArtifact());
        OverlayManager overlayManager = null;
        List overlays = null;
        try {
            overlayManager = new OverlayManager(this.getConfiguredOverlays(), this.mavenProject, this.getDependentWarIncludes(), this.getDependentWarExcludes(), currentProjectOverlay);
            overlays = overlayManager.getOverlays();
        }
        catch (InvalidOverlayConfigurationException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", ex.getMessage(), (Throwable)ex));
        }
        return overlays;
    }

    public String getDependentWarIncludes() {
        return DomUtils.getChildValue(this.getConfiguration(), "dependentWarIncludes", "**/**");
    }

    public String getDependentWarExcludes() {
        return DomUtils.getChildValue(this.getConfiguration(), "dependentWarExcludes", "META-INF/MANIFEST.MF");
    }

    public List<Overlay> getConfiguredOverlays() {
        Xpp3Dom overlaysNode;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (overlaysNode = config.getChild("overlays")) != null && overlaysNode.getChildCount() > 0) {
            ArrayList<Overlay> overlays = new ArrayList<Overlay>(overlaysNode.getChildCount());
            Xpp3Dom[] xpp3DomArray = overlaysNode.getChildren("overlay");
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom overlayNode = xpp3DomArray[n2];
                overlays.add(this.parseOverlay(overlayNode));
                ++n2;
            }
            return overlays;
        }
        return Collections.emptyList();
    }

    private Overlay parseOverlay(Xpp3Dom overlayNode) {
        String artifactId = DomUtils.getChildValue(overlayNode, "artifactId");
        String groupId = DomUtils.getChildValue(overlayNode, "groupId");
        String[] exclusions = DomUtils.getChildrenAsStringArray(overlayNode.getChild("excludes"), "exclude");
        String[] inclusions = DomUtils.getChildrenAsStringArray(overlayNode.getChild("includes"), "include");
        String classifier = DomUtils.getChildValue(overlayNode, "classifier");
        boolean filtered = DomUtils.getBooleanChildValue(overlayNode, "filtered");
        boolean skip = DomUtils.getBooleanChildValue(overlayNode, "skip");
        String type = DomUtils.getChildValue(overlayNode, "type", WAR_PACKAGING);
        String targetPath = DomUtils.getChildValue(overlayNode, "targetPath", "/");
        Overlay overlay = new Overlay();
        overlay.setArtifactId(artifactId);
        overlay.setGroupId(groupId);
        overlay.setClassifier(classifier);
        if (exclusions == null || exclusions.length == 0) {
            overlay.setExcludes(this.getDependentWarExcludes());
        } else {
            overlay.setExcludes(exclusions);
        }
        if (inclusions == null || inclusions.length == 0) {
            overlay.setIncludes(this.getDependentWarIncludes());
        } else {
            overlay.setIncludes(inclusions);
        }
        overlay.setFiltered(filtered);
        overlay.setSkip(skip);
        overlay.setTargetPath(targetPath);
        overlay.setType(type);
        return overlay;
    }

    public FileNameMapping getFileNameMapping() {
        Xpp3Dom config = this.getConfiguration();
        String expression = null;
        if (config != null) {
            expression = DomUtils.getChildValue(config, "outputFileNameMapping");
        }
        return new PatternBasedFileNameMapping(expression);
    }

    @Override
    protected String getFilteringAttribute() {
        return "filteringDeploymentDescriptors";
    }

    public String getWarName() {
        Xpp3Dom config = this.getConfiguration();
        String warName = null;
        if (config != null) {
            warName = DomUtils.getChildValue(config, "warName");
        }
        if (StringUtils.nullOrEmpty(warName)) {
            warName = this.mavenProject.getBuild().getFinalName();
        }
        return warName;
    }

    @Override
    public SourceLocation getSourceLocation() {
        Plugin plugin = this.getPlugin();
        if (plugin == null) {
            return null;
        }
        return SourceLocationHelper.findLocation((Plugin)plugin, (String)"configuration");
    }

    @Override
    public String getSourceIncludeParameterName() {
        return "warSourceIncludes";
    }
}

