/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.wtp.internal.preferences.MavenWtpPreferencesImpl;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferences;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferencesManager;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenWtpPreferencesManagerImpl
implements IMavenWtpPreferencesManager {
    private static Logger LOG = LoggerFactory.getLogger(MavenWtpPreferencesManagerImpl.class);

    @Override
    public IMavenWtpPreferences getPreferences(IProject project) {
        if (project == null) {
            return this.loadWorkspacePreferences();
        }
        IEclipsePreferences eclipsePrefs = MavenWtpPreferencesManagerImpl.getEclipsePreferences(project);
        if (eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.enabledProjectSpecificPrefs", false)) {
            return this.convertPreferences(eclipsePrefs);
        }
        return this.loadWorkspacePreferences();
    }

    @Override
    public IMavenWtpPreferences createNewPreferences() {
        return new MavenWtpPreferencesImpl();
    }

    @Override
    public IMavenWtpPreferences getWorkspacePreferences() {
        return this.loadWorkspacePreferences();
    }

    @Override
    public void savePreferences(IMavenWtpPreferences preferences, IProject project) {
        IEclipsePreferences eclipsePrefs;
        if (preferences == null) {
            return;
        }
        if (project != null) {
            eclipsePrefs = MavenWtpPreferencesManagerImpl.getEclipsePreferences(project);
            if (preferences.isEnabledProjectSpecificSettings()) {
                this.transformPreferences(preferences, eclipsePrefs);
            } else {
                this.removeSpecificSettings(eclipsePrefs);
            }
            eclipsePrefs.putBoolean("org.eclipse.m2e.wtp.enabledProjectSpecificPrefs", preferences.isEnabledProjectSpecificSettings());
        } else {
            eclipsePrefs = MavenWtpPreferencesManagerImpl.getEclipsePreferences();
            this.transformPreferences(preferences, eclipsePrefs);
        }
        try {
            eclipsePrefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("can't store m2e-wtp preferences", (Throwable)e);
        }
    }

    private void removeSpecificSettings(IEclipsePreferences eclipsePrefs) {
        eclipsePrefs.remove("org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir");
        eclipsePrefs.remove("org.eclipse.m2e.wtp.war.archiverFilesInBuilDir");
    }

    private IMavenWtpPreferences loadWorkspacePreferences() {
        return this.convertPreferences(MavenWtpPreferencesManagerImpl.getEclipsePreferences());
    }

    private void transformPreferences(IMavenWtpPreferences preferences, IEclipsePreferences eclipsePrefs) {
        eclipsePrefs.putBoolean("org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir", preferences.isApplicationXmGeneratedInBuildDirectory());
        eclipsePrefs.putBoolean("org.eclipse.m2e.wtp.war.archiverFilesInBuilDir", preferences.isWebMavenArchiverUsesBuildDirectory());
    }

    private IMavenWtpPreferences convertPreferences(IEclipsePreferences eclipsePrefs) {
        IMavenWtpPreferences preferences = this.createNewPreferences();
        preferences.setEnabledProjectSpecificSettings(eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.enabledProjectSpecificPrefs", false));
        preferences.setApplicationXmGeneratedInBuildDirectory(eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir", true));
        preferences.setWebMavenArchiverUsesBuildDirectory(eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.war.archiverFilesInBuilDir", true));
        return preferences;
    }

    private static IEclipsePreferences getEclipsePreferences() {
        return new InstanceScope().getNode("org.eclipse.m2e.wtp");
    }

    private static IEclipsePreferences getEclipsePreferences(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.m2e.wtp");
    }
}

