/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jsf.internal.utils.xpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSFAppConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JSFAppConfigUtils.class);
    public static final String CONFIG_FILES_CONTEXT_PARAM_NAME = "javax.faces.CONFIG_FILES";
    public static final String FACES_CONFIG_IN_JAR_PATH = "META-INF/faces-config.xml";

    public static List<String> getConfigFilesFromContextParam(IProject project) {
        List<String> filesList = Collections.emptyList();
        if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
            try {
                Object webAppObj;
                IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
                if (provider != null && (webAppObj = provider.getModelObject()) != null) {
                    if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                        filesList = JSFAppConfigUtils.getConfigFilesForJ2EEApp(project);
                    } else if (webAppObj instanceof WebApp) {
                        filesList = JSFAppConfigUtils.getConfigFilesForJEEApp((WebApp)webAppObj);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Could not read web.xml", (Throwable)e);
            }
        }
        return filesList;
    }

    private static List<String> getConfigFilesForJEEApp(WebApp webApp) {
        String filesString = null;
        for (ParamValue paramValue : webApp.getContextParams()) {
            if (!paramValue.getParamName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
            filesString = paramValue.getParamValue();
            break;
        }
        return JSFAppConfigUtils.parseFilesString(filesString);
    }

    private static List<String> getConfigFilesForJ2EEApp(IProject project) {
        List<String> filesList;
        block11: {
            filesList = new ArrayList<String>();
            WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
            if (webArtifactEdit != null) {
                try {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = null;
                    try {
                        webApp = webArtifactEdit.getWebApp();
                    }
                    catch (ClassCastException cce) {
                        LOG.error("Error reading web.xml", (Throwable)cce);
                        ArrayList<String> arrayList = filesList;
                        webArtifactEdit.dispose();
                        return arrayList;
                    }
                    if (webApp == null) break block11;
                    String filesString = null;
                    if (webApp.getVersionID() == 23) {
                        EList contexts = webApp.getContexts();
                        for (ContextParam contextParam : contexts) {
                            if (!contextParam.getParamName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
                            filesString = contextParam.getParamValue();
                            break;
                        }
                    } else {
                        EList contextParams = webApp.getContextParams();
                        for (org.eclipse.jst.j2ee.common.ParamValue paramValue : contextParams) {
                            if (!paramValue.getName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
                            filesString = paramValue.getValue();
                            break;
                        }
                    }
                    filesList = JSFAppConfigUtils.parseFilesString(filesString);
                }
                finally {
                    webArtifactEdit.dispose();
                }
            }
        }
        return filesList;
    }

    private static List<String> parseFilesString(String filesString) {
        ArrayList<String> filesList = new ArrayList<String>();
        if (filesString != null && filesString.trim().length() > 0) {
            StringTokenizer stFilesString = new StringTokenizer(filesString, ",");
            while (stFilesString.hasMoreTokens()) {
                String configFile = stFilesString.nextToken().trim();
                filesList.add(configFile);
            }
        }
        return filesList;
    }
}

