/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jpa.internal.util;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JptUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JptUtils.class);

    public static IFile getPersistenceXml(IProject project) {
        ResourceLocator resourceLocator = JptUtils.getResourceLocator(project);
        if (resourceLocator == null) {
            return null;
        }
        IPath path = resourceLocator.getResourcePath(project, (IPath)new Path("META-INF/persistence.xml"));
        IFile persistenceXml = null;
        if (path != null) {
            persistenceXml = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return persistenceXml;
    }

    public static XmlPersistenceUnit getFirstXmlPersistenceUnit(JpaXmlResource persistenceXml) {
        XmlPersistence xmlPersistence;
        EList persistenceUnits;
        if (persistenceXml != null && persistenceXml.getRootObject() instanceof XmlPersistence && (persistenceUnits = (xmlPersistence = (XmlPersistence)persistenceXml.getRootObject()).getPersistenceUnits()) != null && !persistenceUnits.isEmpty()) {
            return (XmlPersistenceUnit)persistenceUnits.get(0);
        }
        return null;
    }

    public static IProjectFacetVersion getVersion(JpaXmlResource persistenceXml) {
        if (persistenceXml == null) {
            return null;
        }
        String version = persistenceXml.getVersion();
        if (version == null || version.trim().length() == 0) {
            return JpaFacet.FACET.getDefaultVersion();
        }
        return JpaFacet.FACET.getVersion(version);
    }

    public static ResourceLocator getResourceLocator(IProject project) {
        try {
            Method getResourceLocator = JptCommonCorePlugin.class.getMethod("getResourceLocator", IProject.class);
            if (getResourceLocator != null) {
                return (ResourceLocator)getResourceLocator.invoke(null, project);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Class<?> resourceLocatorManagerClass = Class.forName("org.eclipse.jpt.common.core.internal.resource.ResourceLocatorManager");
                Object resourceLocatorManager = resourceLocatorManagerClass.getMethod("getInstance", null).invoke(null, null);
                Method getResourceLocator = resourceLocatorManagerClass.getMethod("getResourceLocator", IProject.class);
                if (getResourceLocator != null) {
                    return (ResourceLocator)getResourceLocator.invoke(resourceLocatorManager, project);
                }
            }
            catch (Exception e1) {
                LOG.error("Unable to get a ResourceLocator for " + project, (Throwable)e1);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to get a ResourceLocator for " + project, (Throwable)e);
        }
        return null;
    }
}

