/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.SearchExpression;
import org.eclipse.m2e.core.internal.index.SourcedSearchExpression;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPluginUtils {
    private static Logger log = LoggerFactory.getLogger(MavenPlugin.class);
    private static final String CONFIGURATION_KEY = "configuration";

    private MavenPluginUtils() {
    }

    private static Xpp3Dom getOrCreateConfiguration(Plugin plugin) {
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom(CONFIGURATION_KEY);
            plugin.setConfiguration((Object)configuration);
        }
        return configuration;
    }

    public static void configure(Plugin plugin, String key, String value) {
        if (plugin == null) {
            return;
        }
        Xpp3Dom configuration = MavenPluginUtils.getOrCreateConfiguration(plugin);
        Xpp3Dom keyDom = configuration.getChild(key);
        if (keyDom == null) {
            keyDom = new Xpp3Dom(key);
            configuration.addChild(keyDom);
        }
        keyDom.setValue(value);
    }

    public static String getMostRecentPluginVersion(String groupId, String artifactId, String referenceVersion) {
        Assert.isNotNull((Object)groupId, (String)Messages.MavenPluginUtils_GroupId_Cant_Be_Null);
        Assert.isNotNull((Object)artifactId, (String)Messages.MavenPluginUtils_ArtifactId_Cant_Be_Null);
        String version = referenceVersion;
        String partialKey = String.valueOf(artifactId) + " : " + groupId;
        try {
            IIndex index = MavenPlugin.getIndexManager().getAllIndexes();
            SourcedSearchExpression a = new SourcedSearchExpression(artifactId);
            Map values = index.search((SearchExpression)a, "plugin");
            if (!values.isEmpty()) {
                TreeSet<ComparableVersion> versions = new TreeSet<ComparableVersion>();
                ComparableVersion referenceComparableVersion = referenceVersion == null ? null : new ComparableVersion(referenceVersion);
                for (Map.Entry e : values.entrySet()) {
                    if (!((String)e.getKey()).endsWith(partialKey)) continue;
                    for (IndexedArtifactFile f : ((IndexedArtifact)e.getValue()).getFiles()) {
                        if (!groupId.equals(f.group) || !artifactId.equals(f.artifact) || f.version.contains("-SNAPSHOT")) continue;
                        ComparableVersion v = new ComparableVersion(f.version);
                        if (referenceComparableVersion != null && v.compareTo(referenceComparableVersion) <= 0) continue;
                        versions.add(v);
                    }
                    if (versions.isEmpty()) continue;
                    ArrayList<String> sorted = new ArrayList<String>(versions.size());
                    for (ComparableVersion v : versions) {
                        sorted.add(v.toString());
                    }
                    Collections.reverse(sorted);
                    version = (String)sorted.iterator().next();
                }
            }
        }
        catch (CoreException e) {
            log.error(NLS.bind((String)Messages.MavenPluginUtils_Error_Cant_Retrieve_Latest_Plugin_Version, (Object)partialKey), (Throwable)e);
        }
        return version;
    }
}

