/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.earcreation.EarFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.AbstractProjectConfiguratorDelegate;
import org.eclipse.m2e.wtp.ArtifactHelper;
import org.eclipse.m2e.wtp.DeploymentDescriptorManagement;
import org.eclipse.m2e.wtp.EarPluginConfiguration;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.PackagingConfiguration;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.earmodules.EarModule;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.utilities.PathUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EarProjectConfiguratorDelegate
extends AbstractProjectConfiguratorDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(EarProjectConfiguratorDelegate.class);

    EarProjectConfiguratorDelegate() {
    }

    @Override
    protected void configure(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(NLS.bind((String)Messages.EarProjectConfiguratorDelegate_Configuring_EAR_Project, (Object)project.getName()));
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project.getFile("pom.xml"), true, monitor);
        EarPluginConfiguration config = new EarPluginConfiguration(mavenProject);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        String contentDir = config.getEarContentDirectory(project);
        contentDir = PathUtil.toPortablePath(contentDir);
        IFolder contentFolder = project.getFolder(contentDir);
        ResourceCleaner fileCleaner = new ResourceCleaner(project);
        this.addFoldersToClean(fileCleaner, facade);
        fileCleaner.addFiles(contentFolder.getFile("META-INF/application.xml").getProjectRelativePath());
        IProjectFacetVersion earFv = config.getEarFacetVersion();
        if (!facetedProject.hasProjectFacet(WTPProjectsUtil.EAR_FACET)) {
            WTPProjectsUtil.removeConflictingFacets(facetedProject, earFv, actions);
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, earFv, (Object)this.getEarModel(contentDir)));
        } else {
            IProjectFacetVersion projectFacetVersion = facetedProject.getProjectFacetVersion(WTPProjectsUtil.EAR_FACET);
            if (earFv.getVersionString() != null && !earFv.getVersionString().equals(projectFacetVersion.getVersionString())) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, earFv, (Object)this.getEarModel(contentDir)));
            }
        }
        try {
            if (!actions.isEmpty()) {
                facetedProject.modify(actions, monitor);
            }
        }
        finally {
            try {
                fileCleaner.cleanUp();
            }
            catch (CoreException cex) {
                LOG.error(Messages.Error_Cleaning_WTP_Files, (Throwable)cex);
            }
        }
        this.fixMissingModuleCoreNature(project, monitor);
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)project);
        Path contentDirPath = new Path(contentDir.startsWith("/") ? contentDir : "/" + contentDir);
        if (!WTPProjectsUtil.hasLink(project, ROOT_PATH, (IPath)contentDirPath, monitor)) {
            earComponent.getRootFolder().createLink((IPath)contentDirPath, 0, monitor);
        }
        WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(earComponent.getRootFolder(), (IPath)contentDirPath, monitor);
        boolean useBuildDirectory = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().getPreferences(project).isApplicationXmGeneratedInBuildDirectory();
        ArrayList<IPath> sourcePaths = new ArrayList<IPath>();
        sourcePaths.add((IPath)contentDirPath);
        if (useBuildDirectory) {
            IPath m2eclipseWtpFolderPath = new Path("/").append(ProjectUtils.getM2eclipseWtpFolder(mavenProject, project));
            ProjectUtils.hideM2eclipseWtpFolder(mavenProject, project);
            IPath generatedResourcesPath = m2eclipseWtpFolderPath.append("/ear-resources");
            sourcePaths.add(generatedResourcesPath);
            if (!WTPProjectsUtil.hasLink(project, ROOT_PATH, generatedResourcesPath, monitor)) {
                WTPProjectsUtil.insertLinkBefore(project, generatedResourcesPath, (IPath)contentDirPath, ROOT_PATH, monitor);
            }
        }
        WTPProjectsUtil.deleteLinks(project, ROOT_PATH, sourcePaths, monitor);
        this.removeTestFolderLinks(project, mavenProject, monitor, "/");
        ProjectUtils.removeNature(project, "org.eclipse.jdt.core.javanature", monitor);
        String finalName = config.getFinalName();
        if (!finalName.endsWith(".ear")) {
            finalName = String.valueOf(finalName) + ".ear";
        }
        this.configureDeployedName(project, finalName);
        project.refreshLocal(2, monitor);
        this.addComponentExclusionPatterns(earComponent, config);
        this.setModuleDependencies(project, mavenProject, monitor);
    }

    private IDataModel getEarModel(String contentDir) {
        IDataModel earModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new EarFacetInstallDataModelProvider());
        earModelCfg.setProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR", (Object)contentDir);
        earModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", (Object)false);
        return earModelCfg;
    }

    @Override
    public void setModuleDependencies(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        if (!facetedProject.hasProjectFacet(WTPProjectsUtil.EAR_FACET)) {
            return;
        }
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)project);
        LinkedHashSet<IVirtualReference> newRefs = new LinkedHashSet<IVirtualReference>();
        EarPluginConfiguration config = new EarPluginConfiguration(mavenProject);
        Set<EarModule> earModules = config.getEarModules();
        String libBundleDir = config.getDefaultBundleDirectory();
        this.updateLibDir(project, libBundleDir, monitor);
        PackagingConfiguration packagingConfig = new PackagingConfiguration(config.getPackagingIncludes(), config.getPackagingExcludes());
        for (EarModule earModule : earModules) {
            Artifact artifact = earModule.getArtifact();
            IVirtualComponent depComponent = null;
            IMavenProjectFacade workspaceDependency = this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            if (workspaceDependency != null && !workspaceDependency.getProject().equals((Object)project) && workspaceDependency.getFullPath(artifact.getFile()) != null) {
                IProject depProject = this.preConfigureDependencyProject(workspaceDependency, monitor);
                if (ModuleCoreNature.isFlexibleProject((IProject)depProject)) {
                    depComponent = this.createDependencyComponent(earComponent, depProject);
                }
            } else {
                depComponent = this.createDependencyComponent(earComponent, earModule.getArtifact());
            }
            if (depComponent == null || !packagingConfig.isPackaged(earModule.getUri())) continue;
            IVirtualReference depRef = ComponentCore.createReference((IVirtualComponent)earComponent, (IVirtualComponent)depComponent);
            String bundleDir = StringUtils.isBlank((String)earModule.getBundleDir()) ? "/" : earModule.getBundleDir();
            depRef.setRuntimePath((IPath)new Path(bundleDir));
            depRef.setArchiveName(earModule.getBundleFileName());
            newRefs.add(depRef);
        }
        IVirtualReference[] newRefsArray = new IVirtualReference[newRefs.size()];
        newRefs.toArray(newRefsArray);
        if (this.hasChanged(earComponent.getReferences(), newRefsArray)) {
            earComponent.setReferences(newRefsArray);
        }
        boolean useBuildDirectory = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().getPreferences(project).isApplicationXmGeneratedInBuildDirectory();
        DeploymentDescriptorManagement.INSTANCE.updateConfiguration(project, mavenProject, config, useBuildDirectory, monitor);
    }

    private void updateLibDir(IProject project, String newLibDir, IProgressMonitor monitor) {
        if (!J2EEProjectUtilities.isJEEProject((IProject)project)) {
            return;
        }
        IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)project);
        if (earModel == null) {
            return;
        }
        final Application app = (Application)earModel.getModelObject();
        if (app != null) {
            if (newLibDir == null || "/".equals(newLibDir)) {
                newLibDir = "lib";
            } else if (newLibDir.startsWith("/")) {
                newLibDir = newLibDir.substring(1);
            }
            String oldLibDir = app.getLibraryDirectory();
            if (newLibDir.equals(oldLibDir)) {
                return;
            }
            final String libDir = newLibDir;
            earModel.modify(new Runnable(){

                @Override
                public void run() {
                    app.setLibraryDirectory(libDir);
                }
            }, null);
        }
    }

    private IVirtualComponent createDependencyComponent(IVirtualComponent earComponent, IProject project) {
        IVirtualComponent depComponent = ComponentCore.createComponent((IProject)project);
        return depComponent;
    }

    private IVirtualComponent createDependencyComponent(IVirtualComponent earComponent, Artifact artifact) {
        String artifactPath = ArtifactHelper.getM2REPOVarPath(artifact);
        IVirtualComponent depComponent = ComponentCore.createArchiveComponent((IProject)earComponent.getProject(), (String)artifactPath);
        return depComponent;
    }
}

